/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.angle;

import org.apache.commons.numbers.angle.PlaneAngle;

public final class PlaneAngleRadians {
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_OVER_TWO = 1.5707963267948966;
    public static final double THREE_PI_OVER_TWO = 4.71238898038469;

    private PlaneAngleRadians() {
    }

    public static double normalize(double angle, double center) {
        PlaneAngle a = PlaneAngle.ofRadians(angle);
        PlaneAngle c = PlaneAngle.ofRadians(center);
        return a.normalize(c).toRadians();
    }

    public static double normalizeBetweenMinusPiAndPi(double angle) {
        return PlaneAngle.ofRadians(angle).normalize(PlaneAngle.ZERO).toRadians();
    }

    public static double normalizeBetweenZeroAndTwoPi(double angle) {
        return PlaneAngle.ofRadians(angle).normalize(PlaneAngle.PI).toRadians();
    }
}

