/*
 * Decompiled with CFR 0.152.
 */
package ninja.smirking.events.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Events {
    private static final Logger internalLogger = Logger.getLogger(Events.class.getCanonicalName());
    private static Plugin plugin;

    private Events() {
        throw new UnsupportedOperationException("Events cannot be instantiated!");
    }

    public static <T extends Event> Listener observe(Class<T> eventType, Consumer<? super T> handler) {
        return Events.registerListener(eventType, (listener, event) -> {
            try {
                Events.safeInvoke(eventType, event, handler);
            }
            finally {
                event.getHandlers().unregister(listener);
            }
        });
    }

    private static <T extends Event> Listener registerListener(final Class<T> eventType, final BiConsumer<Listener, ? super T> handler) {
        Preconditions.checkNotNull(eventType, (Object)"eventType");
        Preconditions.checkNotNull(handler, (Object)"handler");
        Listener listener = new Listener(){};
        Events.getPlugin().getServer().getPluginManager().registerEvent(eventType, listener, EventPriority.NORMAL, new EventExecutor(){

            public void execute(Listener listener, Event event) throws EventException {
                if (event.getClass() == eventType) {
                    handler.accept(listener, eventType.cast(event));
                }
            }
        }, plugin, false);
        return listener;
    }

    private static <T extends Event> void safeInvoke(Class<T> type, T event, Consumer<? super T> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler cannot be null");
        Preconditions.checkNotNull(event, (Object)"event cannot be null");
        try {
            handler.accept(event);
        }
        catch (Throwable cause) {
            cause.setStackTrace(Events.getTrimmedTrace(cause));
            String stack = cause.getMessage();
            try (StringWriter stream = new StringWriter();
                 PrintWriter writer = new PrintWriter(stream);){
                cause.printStackTrace(writer);
                stack = stream.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            internalLogger.log(Level.INFO, "An unhandled exception was intercepted whilst handling {0}: \n{1}", new Object[]{type.getName(), stack});
        }
    }

    private static Plugin getPlugin() {
        if (plugin == null) {
            plugin = JavaPlugin.getProvidingPlugin(Events.class);
        }
        return plugin;
    }

    private static StackTraceElement[] getTrimmedTrace(Throwable throwable) {
        ArrayList elements = Lists.newArrayList((Object[])throwable.getStackTrace());
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            StackTraceElement element = (StackTraceElement)iterator.next();
            try {
                Class<?> clazz = Class.forName(element.getClassName(), false, Thread.currentThread().getContextClassLoader());
                if (clazz != Events.class && (!clazz.isAnonymousClass() || clazz.getEnclosingClass() != Events.class)) continue;
                iterator.remove();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return elements.toArray(new StackTraceElement[elements.size()]);
    }

    public static <T extends Event> Listener observeAll(Class<T> eventType, Consumer<? super T> handler) {
        return Events.registerListener(eventType, (listener, event) -> Events.safeInvoke(eventType, event, handler));
    }

    public static <T extends Event> Listener observeIf(Class<T> eventType, Consumer<? super T> handler, Predicate<T> test) {
        return Events.registerListener(eventType, (listener, event) -> {
            if (test.test(event)) {
                Events.safeInvoke(eventType, event, handler);
            }
        });
    }

    public static <T extends Event> Listener observeFor(Class<T> eventType, Consumer<? super T> handler, long duration, TimeUnit unit) {
        return Events.observeFor(eventType, (? super T event, Long time) -> handler.accept(event), duration, unit);
    }

    public static <T extends Event> Listener observeFor(Class<T> eventType, BiConsumer<? super T, Long> handler, long duration, TimeUnit unit) {
        long deadline = Math.addExact(System.currentTimeMillis(), unit.toMillis(duration));
        return Events.registerListener(eventType, (listener, event) -> {
            long invoked = System.currentTimeMillis();
            if (invoked > deadline) {
                event.getHandlers().unregister(listener);
            } else {
                Events.safeInvoke(eventType, event, e -> handler.accept(e, deadline - invoked));
            }
        });
    }
}

