/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.gson;

import com.google.common.base.Strings;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;

public class GsonConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final boolean lenient;
    private final String indent;

    public static Builder builder() {
        return new Builder();
    }

    protected GsonConfigurationLoader(CharSource source, CharSink sink, int indent, boolean lenient, boolean preservesHeader) {
        super(source, sink, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH}, preservesHeader);
        this.lenient = lenient;
        this.indent = Strings.repeat((String)" ", (int)indent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        JsonReader parser;
        block13: {
            parser = new JsonReader((Reader)reader);
            Throwable throwable = null;
            try {
                parser.setLenient(this.lenient);
                this.parseValue(parser, node);
                if (parser == null) return;
                if (throwable == null) break block13;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (parser == null) throw throwable4;
                    if (throwable == null) {
                        parser.close();
                        throw throwable4;
                    }
                    try {
                        parser.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable4;
                        }
                    }
                }
            }
            try {
                parser.close();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    return;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return;
                }
            }
        }
        parser.close();
    }

    private void parseValue(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token = parser.peek();
        switch (token) {
            case BEGIN_OBJECT: {
                this.parseObject(parser, node);
                break;
            }
            case BEGIN_ARRAY: {
                this.parseArray(parser, node);
                break;
            }
            case NUMBER: {
                node.setValue((Object)parser.nextDouble());
                break;
            }
            case STRING: {
                node.setValue((Object)parser.nextString());
                break;
            }
            case BOOLEAN: {
                node.setValue((Object)parser.nextBoolean());
                break;
            }
            case NULL: 
            case NAME: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type: " + token + " (at " + parser.getPath() + ")");
            }
        }
    }

    private void parseArray(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        while ((token = parser.peek()) != null) {
            switch (token) {
                case END_ARRAY: {
                    parser.endArray();
                    return;
                }
            }
            this.parseValue(parser, node.getAppendedNode());
        }
        throw new JsonParseException("Reached end of stream with unclosed array at " + parser.getPath() + "!");
    }

    private void parseObject(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginObject();
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    return;
                }
                case NAME: {
                    this.parseValue(parser, node.getNode(new Object[]{parser.nextName()}));
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + token + " while at " + parser.getPath());
        }
        throw new JsonParseException("Reached end of stream with unclosed object at " + parser.getPath() + "!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        JsonWriter generator;
        block14: {
            if (!this.lenient && !node.hasMapChildren()) {
                throw new IOException("Non-lenient json generators must have children of map type");
            }
            generator = new JsonWriter(writer);
            Throwable throwable = null;
            try {
                generator.setIndent(this.indent);
                generator.setLenient(this.lenient);
                this.generateValue(generator, node);
                generator.flush();
                writer.write(LINE_SEPARATOR);
                if (generator == null) return;
                if (throwable == null) break block14;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (generator == null) throw throwable4;
                    if (throwable == null) {
                        generator.close();
                        throw throwable4;
                    }
                    try {
                        generator.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable4;
                        }
                    }
                }
            }
            try {
                generator.close();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    return;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return;
                }
            }
        }
        generator.close();
    }

    public ConfigurationNode createEmptyNode(ConfigurationOptions options) {
        return SimpleConfigurationNode.root((ConfigurationOptions)options);
    }

    private void generateValue(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (node.hasMapChildren()) {
            this.generateObject(generator, node);
        } else if (node.hasListChildren()) {
            this.generateArray(generator, node);
        } else {
            Object value = node.getValue();
            if (value instanceof Double) {
                generator.value((Number)((Double)value));
            } else if (value instanceof Float) {
                generator.value((Number)((Float)value));
            } else if (value instanceof Long) {
                generator.value((Number)((Long)value));
            } else if (value instanceof Integer) {
                generator.value((Number)((Integer)value));
            } else if (value instanceof Boolean) {
                generator.value(((Boolean)value).booleanValue());
            } else if (!(value instanceof byte[])) {
                generator.value(value.toString());
            }
        }
    }

    private void generateObject(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasMapChildren()) {
            throw new IOException("Node passed to generateObject does not have map children!");
        }
        generator.beginObject();
        for (Map.Entry ent : node.getChildrenMap().entrySet()) {
            generator.name(ent.getKey().toString());
            this.generateValue(generator, (ConfigurationNode)ent.getValue());
        }
        generator.endObject();
    }

    private void generateArray(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasListChildren()) {
            throw new IOException("Node passed to generateArray does not have list children!");
        }
        List children = node.getChildrenList();
        generator.beginArray();
        for (ConfigurationNode child : children) {
            this.generateValue(generator, child);
        }
        generator.endArray();
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder {
        private boolean lenient = true;
        private int indent = 2;

        protected Builder() {
        }

        public Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setFile(File file) {
            super.setFile(file);
            return this;
        }

        public Builder setURL(URL url) {
            super.setURL(url);
            return this;
        }

        public Builder setSource(CharSource source) {
            super.setSource(source);
            return this;
        }

        public Builder setSink(CharSink sink) {
            super.setSink(sink);
            return this;
        }

        public Builder setPreservesHeader(boolean preservesHeader) {
            super.setPreservesHeader(preservesHeader);
            return this;
        }

        public GsonConfigurationLoader build() {
            return new GsonConfigurationLoader(this.source, this.sink, this.indent, this.lenient, this.preserveHeader);
        }
    }
}

