/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;

public class ExceptionConstructor
implements IObjectConstructor {
    private Class<?> type;
    private String pythonExceptionType;

    public ExceptionConstructor(Class<?> type, String module, String name) {
        this.pythonExceptionType = module != null ? module + "." + name : name;
        this.type = type;
    }

    @Override
    public Object construct(Object[] args) {
        try {
            if (this.pythonExceptionType != null) {
                if (args == null || args.length == 0) {
                    args = new String[]{"[" + this.pythonExceptionType + "]"};
                } else {
                    String msg = "[" + this.pythonExceptionType + "] " + (String)args[0];
                    args = new String[]{msg};
                }
            }
            Class[] paramtypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                paramtypes[i] = args[i].getClass();
            }
            Constructor<?> cons = this.type.getConstructor(paramtypes);
            Object ex = cons.newInstance(args);
            try {
                Field prop = ex.getClass().getField("pythonExceptionType");
                prop.set(ex, this.pythonExceptionType);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return ex;
        }
        catch (Exception x) {
            throw new PickleException("problem construction object: " + x);
        }
    }
}

