/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    private final Block.Getter instance;
    private final Point position;

    public BlockUtils(Block.Getter instance, Point position) {
        this.instance = instance;
        this.position = position;
    }

    public BlockUtils getRelativeTo(int x, int y, int z) {
        return new BlockUtils(this.instance, this.position.add(x, y, z));
    }

    public BlockUtils above() {
        return this.getRelativeTo(0, 1, 0);
    }

    public BlockUtils below() {
        return this.getRelativeTo(0, -1, 0);
    }

    public BlockUtils north() {
        return this.getRelativeTo(0, 0, -1);
    }

    public BlockUtils east() {
        return this.getRelativeTo(1, 0, 0);
    }

    public BlockUtils south() {
        return this.getRelativeTo(0, 0, 1);
    }

    public BlockUtils west() {
        return this.getRelativeTo(-1, 0, 0);
    }

    public Block getBlock() {
        return this.instance.getBlock(this.position);
    }

    public boolean equals(Block block) {
        return this.getBlock().compare(block);
    }

    public static Map<String, String> parseProperties(String query) {
        if (!query.startsWith("[") || !query.endsWith("]")) {
            return Map.of();
        }
        if (query.length() == 2) {
            return Map.of();
        }
        int entries = StringUtils.countMatches(query, ',') + 1;
        assert (entries > 0);
        Object[] keys = new String[entries];
        Object[] values = new String[entries];
        int entryCount = 0;
        int length = query.length() - 1;
        int start = 1;
        for (int index = 1; index <= length; ++index) {
            if (query.charAt(index) != ',' && index != length) continue;
            int equalIndex = query.indexOf(61, start);
            if (equalIndex != -1) {
                String key = query.substring(start, equalIndex).trim();
                String value = query.substring(equalIndex + 1, index).trim();
                keys[entryCount] = key;
                values[entryCount++] = value;
            }
            start = index + 1;
        }
        return new Object2ObjectArrayMap(keys, values, entryCount);
    }

    @Nullable
    public static CompoundBinaryTag extractClientNbt(@NotNull Block block) {
        if (!block.registry().isBlockEntity()) {
            return null;
        }
        BlockHandler handler = block.handler();
        CompoundBinaryTag blockNbt = Objects.requireNonNullElseGet(block.nbt(), CompoundBinaryTag::empty);
        if (handler != null) {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            for (Tag<?> tag : handler.getBlockEntityTags()) {
                Object value = tag.read(blockNbt);
                if (value == null) continue;
                tag.writeUnsafe(builder, value);
            }
            return builder.build();
        }
        return blockNbt;
    }

    @NotNull
    public static String toString(@NotNull Block block) {
        if (block.properties().isEmpty()) {
            return block.name();
        }
        StringBuilder builder = new StringBuilder(block.name());
        builder.append('[');
        for (Map.Entry<String, String> entry : block.properties().entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }
}

