/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.function.Function;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagNbtSeparator;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TagSerializerImpl {
    public static final TagSerializer<CompoundBinaryTag> COMPOUND = new TagSerializer<CompoundBinaryTag>(){

        @Override
        @NotNull
        public CompoundBinaryTag read(@NotNull TagReadable reader) {
            return ((TagHandler)reader).asCompound();
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull CompoundBinaryTag value) {
            TagNbtSeparator.separate(value, entry -> writer.setTag(entry.tag(), entry.value()));
        }
    };

    TagSerializerImpl() {
    }

    static <T> TagSerializer<T> fromCompound(final Function<CompoundBinaryTag, T> readFunc, final Function<T, CompoundBinaryTag> writeFunc) {
        return new TagSerializer<T>(){

            @Override
            @Nullable
            public T read(@NotNull TagReadable reader) {
                CompoundBinaryTag compound = (CompoundBinaryTag)COMPOUND.read(reader);
                return readFunc.apply(compound);
            }

            @Override
            public void write(@NotNull TagWritable writer, @NotNull T value) {
                CompoundBinaryTag compound = (CompoundBinaryTag)writeFunc.apply(value);
                COMPOUND.write(writer, compound);
            }
        };
    }
}

