/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.sound;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.sound.BuiltinSoundEvent;
import net.minestom.server.sound.CustomSoundEvent;
import net.minestom.server.sound.SoundEvents;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SoundEvent
extends ProtocolObject,
Keyed,
Sound.Type,
SoundEvents
permits BuiltinSoundEvent, CustomSoundEvent {
    @NotNull
    public static final NetworkBuffer.Type<SoundEvent> NETWORK_TYPE = new NetworkBuffer.Type<SoundEvent>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, SoundEvent value) {
            SoundEvent soundEvent = value;
            Objects.requireNonNull(soundEvent);
            SoundEvent soundEvent2 = soundEvent;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinSoundEvent.class, CustomSoundEvent.class}, (Object)soundEvent2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BuiltinSoundEvent soundEvent3 = (BuiltinSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, soundEvent3.id() + 1);
                    break;
                }
                case 1: {
                    CustomSoundEvent soundEvent4 = (CustomSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.STRING, soundEvent4.name());
                    buffer.write(NetworkBuffer.FLOAT.optional(), soundEvent4.range());
                }
            }
        }

        @Override
        public SoundEvent read(@NotNull NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (id != -1) {
                return BuiltinSoundEvent.getId(id);
            }
            NamespaceID namespace = NamespaceID.from(buffer.read(NetworkBuffer.STRING));
            return new CustomSoundEvent(namespace, buffer.read(NetworkBuffer.FLOAT.optional()));
        }
    };
    @NotNull
    public static final BinaryTagSerializer<SoundEvent> NBT_TYPE = new BinaryTagSerializer<SoundEvent>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull SoundEvent value) {
            SoundEvent soundEvent = value;
            Objects.requireNonNull(soundEvent);
            SoundEvent soundEvent2 = soundEvent;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinSoundEvent.class, CustomSoundEvent.class}, (Object)soundEvent2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BuiltinSoundEvent soundEvent = (BuiltinSoundEvent)soundEvent2;
                    yield StringBinaryTag.stringBinaryTag((String)soundEvent.name());
                }
                case 1 -> {
                    CustomSoundEvent soundEvent = (CustomSoundEvent)soundEvent2;
                    CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("sound_id", soundEvent.name());
                    if (soundEvent.range() != null) {
                        builder.putFloat("range", soundEvent.range().floatValue());
                    }
                    yield builder.build();
                }
            };
        }

        @Override
        @NotNull
        public SoundEvent read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag tag) {
            if (tag instanceof CompoundBinaryTag) {
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                String soundId = compound.getString("sound_id");
                Float range = Float.valueOf(compound.getFloat("range"));
                return new CustomSoundEvent(NamespaceID.from(soundId), range);
            }
            return BuiltinSoundEvent.getSafe(((StringBinaryTag)tag).value());
        }
    };

    @NotNull
    public static Collection<? extends SoundEvent> values() {
        return BuiltinSoundEvent.values();
    }

    @Nullable
    public static SoundEvent fromNamespaceId(@NotNull String namespaceID) {
        return BuiltinSoundEvent.getSafe(namespaceID);
    }

    @Nullable
    public static SoundEvent fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return SoundEvent.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static SoundEvent fromId(int id) {
        return BuiltinSoundEvent.getId(id);
    }

    @NotNull
    public static SoundEvent of(@NotNull String namespaceID, @Nullable Float range) {
        return new CustomSoundEvent(NamespaceID.from(namespaceID), range);
    }

    @NotNull
    public static SoundEvent of(@NotNull NamespaceID namespaceID, @Nullable Float range) {
        return new CustomSoundEvent(namespaceID, range);
    }

    @Contract(pure=true)
    @NotNull
    public NamespaceID namespace();

    @Contract(pure=true)
    @NotNull
    default public String name() {
        return this.namespace().asString();
    }

    @Contract(pure=true)
    @NotNull
    default public Key key() {
        return this.namespace();
    }
}

