/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.common;

import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientResourcePackStatusPacket(@NotNull UUID id, @NotNull ResourcePackStatus status) implements ClientPacket
{
    public static final NetworkBuffer.Type<ClientResourcePackStatusPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.UUID, ClientResourcePackStatusPacket::id, NetworkBuffer.VAR_INT.transform(ClientResourcePackStatusPacket::readStatus, ClientResourcePackStatusPacket::statusId), ClientResourcePackStatusPacket::status, ClientResourcePackStatusPacket::new);

    @NotNull
    private static ResourcePackStatus readStatus(int id) {
        return switch (id) {
            case 0 -> ResourcePackStatus.SUCCESSFULLY_LOADED;
            case 1 -> ResourcePackStatus.DECLINED;
            case 2 -> ResourcePackStatus.FAILED_DOWNLOAD;
            case 3 -> ResourcePackStatus.ACCEPTED;
            case 4 -> ResourcePackStatus.DOWNLOADED;
            case 5 -> ResourcePackStatus.INVALID_URL;
            case 6 -> ResourcePackStatus.FAILED_RELOAD;
            case 7 -> ResourcePackStatus.DISCARDED;
            default -> throw new IllegalStateException("Unexpected resource pack status: " + id);
        };
    }

    private static int statusId(@NotNull ResourcePackStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ResourcePackStatus.SUCCESSFULLY_LOADED -> 0;
            case ResourcePackStatus.DECLINED -> 1;
            case ResourcePackStatus.FAILED_DOWNLOAD -> 2;
            case ResourcePackStatus.ACCEPTED -> 3;
            case ResourcePackStatus.DOWNLOADED -> 4;
            case ResourcePackStatus.INVALID_URL -> 5;
            case ResourcePackStatus.FAILED_RELOAD -> 6;
            case ResourcePackStatus.DISCARDED -> 7;
        };
    }
}

