/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import java.util.Objects;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;

public final class CreativeInventoryActionListener {
    public static void listener(ClientCreativeInventoryActionPacket packet, Player player) {
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        short slot = packet.slot();
        ItemStack item = packet.item();
        if (slot == -1) {
            player.dropItem(item);
            return;
        }
        if (slot < 1 || slot > 45) {
            return;
        }
        slot = (short)PlayerInventoryUtils.convertWindow0SlotToMinestomSlot(slot);
        PlayerInventory inventory = player.getInventory();
        if (Objects.equals(inventory.getItemStack(slot), item)) {
            return;
        }
        inventory.setItemStack(slot, item);
    }
}

