/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public non-sealed interface ValueEffect
extends Enchantment.Effect {
    @NotNull
    public static final BinaryTagSerializer<ValueEffect> NBT_TYPE = BinaryTagSerializer.registryTaggedUnion(Registries::enchantmentValueEffects, ValueEffect::nbtType, "type");

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<BinaryTagSerializer<? extends ValueEffect>> createDefaultRegistry() {
        DynamicRegistry<BinaryTagSerializer<? extends ValueEffect>> registry = DynamicRegistry.create("minestom:enchantment_value_effect");
        registry.register("add", Add.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("all_of", AllOf.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("multiply", Multiply.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("remove_binomial", RemoveBinomial.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("set", Set.NBT_TYPE, DataPack.MINECRAFT_CORE);
        return registry;
    }

    public float apply(float var1, int var2);

    @NotNull
    public BinaryTagSerializer<? extends ValueEffect> nbtType();

    public record Add(@NotNull LevelBasedValue value) implements ValueEffect
    {
        public static final BinaryTagSerializer<Add> NBT_TYPE = BinaryTagSerializer.object("value", LevelBasedValue.NBT_TYPE, Add::value, Add::new);

        @Override
        public float apply(float base, int level) {
            return base + this.value.calc(level);
        }

        @NotNull
        public BinaryTagSerializer<Add> nbtType() {
            return NBT_TYPE;
        }
    }

    public record AllOf(@NotNull List<ValueEffect> effects) implements ValueEffect
    {
        public static final BinaryTagSerializer<AllOf> NBT_TYPE = BinaryTagSerializer.object("effects", NBT_TYPE.list(), AllOf::effects, AllOf::new);

        public AllOf(@NotNull List<ValueEffect> effects) {
            effects = List.copyOf(effects);
        }

        @Override
        public float apply(float base, int level) {
            for (ValueEffect effect : this.effects) {
                base = effect.apply(base, level);
            }
            return base;
        }

        @NotNull
        public BinaryTagSerializer<AllOf> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Multiply(@NotNull LevelBasedValue factor) implements ValueEffect
    {
        public static final BinaryTagSerializer<Multiply> NBT_TYPE = BinaryTagSerializer.object("factor", LevelBasedValue.NBT_TYPE, Multiply::factor, Multiply::new);

        @Override
        public float apply(float base, int level) {
            return base * this.factor.calc(level);
        }

        @NotNull
        public BinaryTagSerializer<Multiply> nbtType() {
            return NBT_TYPE;
        }
    }

    public record RemoveBinomial(@NotNull LevelBasedValue chance) implements ValueEffect
    {
        public static final BinaryTagSerializer<RemoveBinomial> NBT_TYPE = BinaryTagSerializer.object("chance", LevelBasedValue.NBT_TYPE, RemoveBinomial::chance, RemoveBinomial::new);

        @Override
        public float apply(float base, int level) {
            throw new UnsupportedOperationException("todo");
        }

        @NotNull
        public BinaryTagSerializer<RemoveBinomial> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Set(@NotNull LevelBasedValue value) implements ValueEffect
    {
        public static final BinaryTagSerializer<Set> NBT_TYPE = BinaryTagSerializer.object("value", LevelBasedValue.NBT_TYPE, Set::value, Set::new);

        @Override
        public float apply(float base, int level) {
            return this.value.calc(level);
        }

        @NotNull
        public BinaryTagSerializer<Set> nbtType() {
            return NBT_TYPE;
        }
    }
}

