/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.nbt.BinaryTagTemplate;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record JukeboxPlayable(@NotNull DynamicRegistry.Key<JukeboxSong> song, boolean showInTooltip) {
    public static final NetworkBuffer.Type<JukeboxPlayable> NETWORK_TYPE = new NetworkBuffer.Type<JukeboxPlayable>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, JukeboxPlayable value) {
            buffer.write(NetworkBuffer.BOOLEAN, true);
            buffer.write(JukeboxSong.NETWORK_TYPE, value.song);
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        public JukeboxPlayable read(@NotNull NetworkBuffer buffer) {
            DynamicRegistry.Key<JukeboxSong> song;
            if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
                song = buffer.read(JukeboxSong.NETWORK_TYPE);
            } else {
                song = DynamicRegistry.Key.of(buffer.read(NetworkBuffer.STRING));
                DynamicRegistry<JukeboxSong> registry = MinecraftServer.getJukeboxSongRegistry();
                Check.stateCondition(registry.get(song) != null, "unknown song: {0}", song);
            }
            return new JukeboxPlayable(song, buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<JukeboxPlayable> NBT_TYPE = BinaryTagTemplate.object("song", JukeboxSong.NBT_TYPE, JukeboxPlayable::song, "show_in_tooltip", BinaryTagSerializer.BOOLEAN.optional(true), JukeboxPlayable::showInTooltip, JukeboxPlayable::new);

    public JukeboxPlayable(@NotNull DynamicRegistry.Key<JukeboxSong> song) {
        this(song, true);
    }

    @NotNull
    public JukeboxPlayable withSong(@NotNull DynamicRegistry.Key<JukeboxSong> song) {
        return new JukeboxPlayable(song, this.showInTooltip);
    }

    @NotNull
    public JukeboxPlayable withTooltip(boolean showInTooltip) {
        return new JukeboxPlayable(this.song, showInTooltip);
    }
}

