/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record ItemBlockState(@NotNull Map<String, String> properties) {
    public static final ItemBlockState EMPTY = new ItemBlockState(Map.of());
    public static final NetworkBuffer.Type<ItemBlockState> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.mapValue(NetworkBuffer.STRING), ItemBlockState::properties, ItemBlockState::new);
    public static final BinaryTagSerializer<ItemBlockState> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        HashMap<String, String> properties = new HashMap<String, String>(tag.size());
        for (Map.Entry entry : tag) {
            Object patt0$temp = entry.getValue();
            if (!(patt0$temp instanceof StringBinaryTag)) continue;
            StringBinaryTag str = (StringBinaryTag)patt0$temp;
            properties.put((String)entry.getKey(), str.value());
        }
        return new ItemBlockState(properties);
    }, value -> {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        for (Map.Entry<String, String> entry : value.properties.entrySet()) {
            builder.put(entry.getKey(), (BinaryTag)StringBinaryTag.stringBinaryTag((String)entry.getValue()));
        }
        return builder.build();
    });

    public ItemBlockState(@NotNull Map<String, String> properties) {
        properties = Map.copyOf(properties);
    }

    @NotNull
    public ItemBlockState with(@NotNull String key, @NotNull String value) {
        HashMap<String, String> newProperties = new HashMap<String, String>(this.properties);
        newProperties.put(key, value);
        return new ItemBlockState(newProperties);
    }

    @NotNull
    public Block apply(@NotNull Block block) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (block.getProperty(entry.getKey()) == null) continue;
            block = block.withProperty(entry.getKey(), entry.getValue());
        }
        return block;
    }
}

