/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.PaletteIndirect;
import net.minestom.server.instance.palette.PaletteSingle;
import net.minestom.server.instance.palette.SpecializedPalette;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;

final class AdaptivePalette
implements Palette,
Cloneable {
    final byte dimension;
    final byte defaultBitsPerEntry;
    final byte maxBitsPerEntry;
    SpecializedPalette palette;

    AdaptivePalette(byte dimension, byte maxBitsPerEntry, byte bitsPerEntry) {
        AdaptivePalette.validateDimension(dimension);
        this.dimension = dimension;
        this.maxBitsPerEntry = maxBitsPerEntry;
        this.defaultBitsPerEntry = bitsPerEntry;
        this.palette = new PaletteSingle(dimension, 0);
    }

    @Override
    public int get(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            throw new IllegalArgumentException("Coordinates must be positive");
        }
        return this.palette.get(x, y, z);
    }

    @Override
    public void getAll(@NotNull Palette.EntryConsumer consumer) {
        this.palette.getAll(consumer);
    }

    @Override
    public void getAllPresent(@NotNull Palette.EntryConsumer consumer) {
        this.palette.getAllPresent(consumer);
    }

    @Override
    public void set(int x, int y, int z, int value) {
        if (x < 0 || y < 0 || z < 0) {
            throw new IllegalArgumentException("Coordinates must be positive");
        }
        this.flexiblePalette().set(x, y, z, value);
    }

    @Override
    public void fill(int value) {
        this.palette = new PaletteSingle(this.dimension, value);
    }

    @Override
    public void setAll(@NotNull Palette.EntrySupplier supplier) {
        PaletteIndirect newPalette = new PaletteIndirect(this);
        newPalette.setAll(supplier);
        this.palette = newPalette;
    }

    @Override
    public void replace(int x, int y, int z, @NotNull IntUnaryOperator operator) {
        if (x < 0 || y < 0 || z < 0) {
            throw new IllegalArgumentException("Coordinates must be positive");
        }
        this.flexiblePalette().replace(x, y, z, operator);
    }

    @Override
    public void replaceAll(@NotNull Palette.EntryFunction function) {
        this.flexiblePalette().replaceAll(function);
    }

    @Override
    public int count() {
        return this.palette.count();
    }

    @Override
    public int bitsPerEntry() {
        return this.palette.bitsPerEntry();
    }

    @Override
    public int maxBitsPerEntry() {
        return this.maxBitsPerEntry;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    @NotNull
    public Palette clone() {
        try {
            AdaptivePalette adaptivePalette = (AdaptivePalette)super.clone();
            adaptivePalette.palette = this.palette.clone();
            return adaptivePalette;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    SpecializedPalette optimizedPalette() {
        SpecializedPalette currentPalette = this.palette;
        if (currentPalette instanceof PaletteIndirect) {
            int bitsPerEntry;
            PaletteIndirect paletteIndirect = (PaletteIndirect)currentPalette;
            int count = paletteIndirect.count();
            if (count == 0) {
                return new PaletteSingle(this.dimension, 0);
            }
            IntOpenHashSet entries = new IntOpenHashSet(paletteIndirect.paletteToValueList.size());
            paletteIndirect.getAll((arg_0, arg_1, arg_2, arg_3) -> AdaptivePalette.lambda$optimizedPalette$0((IntSet)entries, arg_0, arg_1, arg_2, arg_3));
            int currentBitsPerEntry = paletteIndirect.bitsPerEntry();
            if (entries.size() == 1) {
                return new PaletteSingle(this.dimension, entries.iterator().nextInt());
            }
            if (currentBitsPerEntry > this.defaultBitsPerEntry && (bitsPerEntry = MathUtils.bitsToRepresent(entries.size() - 1)) < currentBitsPerEntry) {
                paletteIndirect.resize((byte)bitsPerEntry);
                return paletteIndirect;
            }
        }
        return currentPalette;
    }

    Palette flexiblePalette() {
        SpecializedPalette currentPalette = this.palette;
        if (currentPalette instanceof PaletteSingle) {
            PaletteSingle paletteSingle = (PaletteSingle)currentPalette;
            currentPalette = new PaletteIndirect(this);
            currentPalette.fill(paletteSingle.value());
            this.palette = currentPalette;
        }
        return currentPalette;
    }

    private static void validateDimension(int dimension) {
        if (dimension <= 1 || (dimension & dimension - 1) != 0) {
            throw new IllegalArgumentException("Dimension must be a positive power of 2");
        }
    }

    private static /* synthetic */ void lambda$optimizedPalette$0(IntSet entries, int x, int y, int z, int value) {
        entries.add(value);
    }
}

