/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventBinding;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.EventNodeImpl;
import net.minestom.server.event.ListenerHandle;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface EventNode<T extends Event>
permits EventNodeImpl {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static EventNode<Event> all(@NotNull String name) {
        return EventNode.type(name, EventFilter.ALL);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <E extends Event, V> EventNode<E> type(@NotNull String name, @NotNull EventFilter<E, V> filter) {
        return EventNode.create(name, filter, null);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Event, V> EventNode<E> event(@NotNull String name, @NotNull EventFilter<E, V> filter, @NotNull Predicate<E> predicate) {
        return EventNode.create(name, filter, (e, h) -> predicate.test(e));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Event, V> EventNode<E> type(@NotNull String name, @NotNull EventFilter<E, V> filter, @NotNull BiPredicate<E, V> predicate) {
        return EventNode.create(name, filter, predicate);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Event, V> EventNode<E> value(@NotNull String name, @NotNull EventFilter<E, V> filter, @NotNull Predicate<V> predicate) {
        return EventNode.create(name, filter, (e, h) -> predicate.test(h));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Event> EventNode<E> tag(@NotNull String name, @NotNull EventFilter<E, ? extends TagReadable> filter, @NotNull Tag<?> tag) {
        return EventNode.create(name, filter, (e, h) -> h.hasTag(tag));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <E extends Event, V> EventNode<E> tag(@NotNull String name, @NotNull EventFilter<E, ? extends TagReadable> filter, @NotNull Tag<V> tag, @NotNull Predicate<@Nullable V> consumer) {
        return EventNode.create(name, filter, (e, h) -> consumer.test(h.getTag(tag)));
    }

    private static <E extends Event, V> EventNode<E> create(@NotNull String name, @NotNull EventFilter<E, V> filter, @Nullable BiPredicate<E, V> predicate) {
        return new EventNodeImpl<Event>(name, filter, predicate != null ? (e, o) -> predicate.test(e, o) : null);
    }

    default public void call(@NotNull T event) {
        this.getHandle(event.getClass()).call(event);
    }

    default public boolean hasListener(@NotNull Class<? extends T> type) {
        return this.getHandle(type).hasListener();
    }

    @ApiStatus.Experimental
    @NotNull
    public <E extends T> ListenerHandle<E> getHandle(@NotNull Class<E> var1);

    default public void callCancellable(@NotNull T event, @NotNull Runnable successCallback) {
        CancellableEvent cancellableEvent;
        this.call(event);
        if (!(event instanceof CancellableEvent) || !(cancellableEvent = (CancellableEvent)event).isCancelled()) {
            successCallback.run();
        }
    }

    @Contract(pure=true)
    @NotNull
    public Class<T> getEventType();

    @Contract(pure=true)
    @NotNull
    public String getName();

    @Contract(pure=true)
    public int getPriority();

    @Contract(value="_ -> this")
    @NotNull
    public EventNode<T> setPriority(int var1);

    @Contract(pure=true)
    @Nullable
    public EventNode<? super T> getParent();

    @Contract(pure=true)
    @NotNull
    public @NotNull Set<@NotNull EventNode<T>> getChildren();

    @Contract(pure=true)
    @NotNull
    public <E extends T> List<EventNode<E>> findChildren(@NotNull String var1, Class<E> var2);

    @Contract(pure=true)
    @NotNull
    default public List<EventNode<T>> findChildren(@NotNull String name) {
        return this.findChildren(name, this.getEventType());
    }

    public <E extends T> void replaceChildren(@NotNull String var1, @NotNull Class<E> var2, @NotNull EventNode<E> var3);

    default public void replaceChildren(@NotNull String name, @NotNull EventNode<T> eventNode) {
        this.replaceChildren(name, this.getEventType(), eventNode);
    }

    public void removeChildren(@NotNull String var1, @NotNull Class<? extends T> var2);

    default public void removeChildren(@NotNull String name) {
        this.removeChildren(name, this.getEventType());
    }

    @Contract(value="_ -> this")
    @NotNull
    public EventNode<T> addChild(@NotNull EventNode<? extends T> var1);

    @Contract(value="_ -> this")
    @NotNull
    public EventNode<T> removeChild(@NotNull EventNode<? extends T> var1);

    @Contract(value="_ -> this")
    @NotNull
    public EventNode<T> addListener(@NotNull EventListener<? extends T> var1);

    @Contract(value="_, _ -> this")
    @NotNull
    default public <E extends T> EventNode<T> addListener(@NotNull Class<E> eventType, @NotNull @NotNull Consumer<@NotNull E> listener) {
        return this.addListener(EventListener.of(eventType, listener));
    }

    @Contract(value="_ -> this")
    @NotNull
    public EventNode<T> removeListener(@NotNull EventListener<? extends T> var1);

    @ApiStatus.Experimental
    @NotNull
    public <E extends T, H> EventNode<E> map(@NotNull H var1, @NotNull EventFilter<E, H> var2);

    @ApiStatus.Experimental
    public void unmap(@NotNull Object var1);

    @ApiStatus.Experimental
    public void register(@NotNull EventBinding<? extends T> var1);

    @ApiStatus.Experimental
    public void unregister(@NotNull EventBinding<? extends T> var1);
}

