/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import net.minestom.server.color.DyeColor;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.tameable.TameableAnimalMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public class CatMeta
extends TameableAnimalMeta {
    private static final DyeColor[] DYE_VALUES = DyeColor.values();

    public CatMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return this.metadata.get(MetadataDef.Cat.VARIANT);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.set(MetadataDef.Cat.VARIANT, value);
    }

    public boolean isLying() {
        return this.metadata.get(MetadataDef.Cat.IS_LYING);
    }

    public void setLying(boolean value) {
        this.metadata.set(MetadataDef.Cat.IS_LYING, value);
    }

    public boolean isRelaxed() {
        return this.metadata.get(MetadataDef.Cat.IS_RELAXED);
    }

    public void setRelaxed(boolean value) {
        this.metadata.set(MetadataDef.Cat.IS_RELAXED, value);
    }

    @NotNull
    public DyeColor getCollarColor() {
        return DYE_VALUES[this.metadata.get(MetadataDef.Cat.COLLAR_COLOR)];
    }

    public void setCollarColor(@NotNull DyeColor value) {
        this.metadata.set(MetadataDef.Cat.COLLAR_COLOR, value.ordinal());
    }

    public static enum Variant {
        TABBY,
        BLACK,
        RED,
        SIAMESE,
        BRITISH_SHORTHAIR,
        CALICO,
        PERSIAN,
        RAGDOLL,
        WHITE,
        JELLIE,
        ALL_BLACK;

        public static final NetworkBuffer.Type<Variant> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Variant.class);
        }
    }
}

