/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DamageTypeImpl
extends Record
implements DamageType {
    private final float exhaustion;
    @NotNull
    private final String messageId;
    @NotNull
    private final String scaling;
    @Nullable
    private final Registry.DamageTypeEntry registry;
    static final BinaryTagSerializer<DamageType> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("DamageType is read-only");
    }, damageType -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putFloat("exhaustion", damageType.exhaustion())).putString("message_id", damageType.messageId())).putString("scaling", damageType.scaling())).build());

    DamageTypeImpl(float exhaustion, @NotNull String messageId, @NotNull String scaling, @Nullable Registry.DamageTypeEntry registry) {
        Check.argCondition(messageId == null || messageId.isEmpty(), "missing message id");
        Check.argCondition(scaling == null || scaling.isEmpty(), "missing scaling");
        this.exhaustion = exhaustion;
        this.messageId = messageId;
        this.scaling = scaling;
        this.registry = registry;
    }

    DamageTypeImpl(@NotNull Registry.DamageTypeEntry registry) {
        this(registry.exhaustion(), registry.messageId(), registry.scaling(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DamageTypeImpl.class, "exhaustion;messageId;scaling;registry", "exhaustion", "messageId", "scaling", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DamageTypeImpl.class, "exhaustion;messageId;scaling;registry", "exhaustion", "messageId", "scaling", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DamageTypeImpl.class, "exhaustion;messageId;scaling;registry", "exhaustion", "messageId", "scaling", "registry"}, this, o);
    }

    @Override
    public float exhaustion() {
        return this.exhaustion;
    }

    @Override
    @NotNull
    public String messageId() {
        return this.messageId;
    }

    @Override
    @NotNull
    public String scaling() {
        return this.scaling;
    }

    @Override
    @Nullable
    public Registry.DamageTypeEntry registry() {
        return this.registry;
    }
}

