/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.inventory;

public final class PlayerInventoryUtils {
    public static final int OFFSET = 9;
    public static final int CRAFT_RESULT = 36;
    public static final int CRAFT_SLOT_1 = 37;
    public static final int CRAFT_SLOT_2 = 38;
    public static final int CRAFT_SLOT_3 = 39;
    public static final int CRAFT_SLOT_4 = 40;
    public static final int HELMET_SLOT = 41;
    public static final int CHESTPLATE_SLOT = 42;
    public static final int LEGGINGS_SLOT = 43;
    public static final int BOOTS_SLOT = 44;
    public static final int OFFHAND_SLOT = 45;

    private PlayerInventoryUtils() {
    }

    public static int convertPlayerInventorySlot(int slot, int offset) {
        return switch (slot) {
            case 0 -> 36;
            case 1 -> 37;
            case 2 -> 38;
            case 3 -> 39;
            case 4 -> 40;
            case 5 -> 41;
            case 6 -> 42;
            case 7 -> 43;
            case 8 -> 44;
            default -> PlayerInventoryUtils.convertSlot(slot, offset);
        };
    }

    public static int convertSlot(int slot, int offset) {
        int rowSize = 9;
        slot = (slot -= offset) >= 27 && slot < 36 ? (slot %= 9) : (slot += 9);
        return slot;
    }

    public static int convertToPacketSlot(int slot) {
        if (slot > -1 && slot < 9) {
            slot += 36;
        } else if (slot <= 8 || slot >= 36) {
            if (slot >= 36 && slot <= 40) {
                slot -= 36;
            } else if (slot >= 41 && slot <= 44) {
                slot -= 36;
            } else if (slot == 45) {
                slot = 45;
            }
        }
        return slot;
    }

    public static int convertClientInventorySlot(int slot) {
        if (slot == 36) {
            return 44;
        }
        if (slot == 37) {
            return 43;
        }
        if (slot == 38) {
            return 42;
        }
        if (slot == 39) {
            return 41;
        }
        if (slot == 40) {
            return 45;
        }
        return slot;
    }
}

