/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.thread.MinestomThread;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TickSchedulerThread
extends MinestomThread {
    private static final long TICK_TIME_NANOS = 1000000000L / (long)ServerFlag.SERVER_TICKS_PER_SECOND;
    private static final long SLEEP_THRESHOLD = System.getProperty("os.name", "").toLowerCase().startsWith("windows") ? 17L : 2L;
    private final ServerProcess serverProcess;

    public TickSchedulerThread(ServerProcess serverProcess) {
        super("Ms-TickScheduler");
        this.serverProcess = serverProcess;
    }

    @Override
    public void run() {
        long ticks = 0L;
        long baseTime = System.nanoTime();
        while (this.serverProcess.isAlive()) {
            long tickStart = System.nanoTime();
            try {
                this.serverProcess.ticker().tick(tickStart);
            }
            catch (Exception e) {
                this.serverProcess.exception().handleException(e);
            }
            long nextTickTime = baseTime + ++ticks * TICK_TIME_NANOS;
            this.waitUntilNextTick(nextTickTime);
            if (System.nanoTime() <= nextTickTime + TICK_TIME_NANOS * (long)ServerFlag.SERVER_MAX_TICK_CATCH_UP) continue;
            baseTime = System.nanoTime();
            ticks = 0L;
        }
    }

    private void waitUntilNextTick(long nextTickTimeNanos) {
        long currentTime;
        while ((currentTime = System.nanoTime()) < nextTickTimeNanos) {
            long remainingTime = nextTickTimeNanos - currentTime;
            long remainingMilliseconds = remainingTime / 1000000L;
            if (remainingMilliseconds < SLEEP_THRESHOLD) continue;
            this.sleepThread(remainingMilliseconds / 2L);
        }
    }

    private void sleepThread(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.serverProcess.exception().handleException(e);
        }
    }
}

