/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.ServerFlag;
import net.minestom.server.tag.Serializers;
import net.minestom.server.tag.StaticIntMap;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagNbtSeparator;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class TagHandlerImpl
implements TagHandler {
    static final Serializers.Entry<Node, CompoundBinaryTag> NODE_SERIALIZER = new Serializers.Entry<Node, CompoundBinaryTag>(BinaryTagTypes.COMPOUND, entries -> TagHandlerImpl.fromCompound((CompoundBinaryTag)entries).root, Node::compound, true);
    private final Node root;
    private volatile Node copy;

    TagHandlerImpl(Node root) {
        this.root = root;
    }

    TagHandlerImpl() {
        this.root = new Node();
    }

    static TagHandlerImpl fromCompound(CompoundBinaryTag compound) {
        TagHandlerImpl handler = new TagHandlerImpl();
        TagNbtSeparator.separate(compound, entry -> handler.setTag(entry.tag(), entry.value()));
        handler.root.compound = compound;
        return handler;
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        VarHandle.fullFence();
        return this.root.getTag(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setTag(@NotNull Tag<T> tag, @Nullable T value) {
        if (tag.isView()) {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                Node syncNode = this.traversePathWrite(this.root, tag, value != null);
                if (syncNode != null) {
                    syncNode.updateContent(value != null ? (CompoundBinaryTag)tag.entry.write(value) : CompoundBinaryTag.empty());
                    syncNode.invalidate();
                }
            }
            return;
        }
        int tagIndex = tag.index;
        VarHandle.fullFence();
        Node node = this.traversePathWrite(this.root, tag, value != null);
        if (node == null) {
            return;
        }
        StaticIntMap<Entry<?>> entries = node.entries;
        if (value != null) {
            Entry<?> previous = entries.get(tagIndex);
            if (previous != null && previous.tag.shareValue(tag)) {
                previous.updateValue(tag.copyValue(value));
            } else {
                TagHandlerImpl tagHandlerImpl = this;
                synchronized (tagHandlerImpl) {
                    node = this.traversePathWrite(this.root, tag, true);
                    node.entries.put(tagIndex, this.valueToEntry(node, tag, value));
                }
            }
        } else {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                node = this.traversePathWrite(this.root, tag, false);
                if (node == null) {
                    return;
                }
                node.entries.remove(tagIndex);
            }
        }
        node.invalidate();
    }

    @Override
    @Nullable
    public <T> T getAndSetTag(@NotNull Tag<T> tag, @Nullable T value) {
        return this.updateTag0(tag, t -> value, true);
    }

    @Override
    public <T> void updateTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        this.updateTag0(tag, value, false);
    }

    @Override
    public <T> @UnknownNullability T updateAndGetTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        return this.updateTag0(tag, value, false);
    }

    @Override
    public <T> @UnknownNullability T getAndUpdateTag(@NotNull Tag<T> tag, @NotNull UnaryOperator<@UnknownNullability T> value) {
        return this.updateTag0(tag, value, true);
    }

    private synchronized <T> T updateTag0(@NotNull Tag<T> tag, @NotNull UnaryOperator<T> value, boolean returnPrevious) {
        T previousValue;
        Node node = this.traversePathWrite(this.root, tag, true);
        if (tag.isView()) {
            T previousValue2 = tag.read(node.compound());
            Object newValue = value.apply(previousValue2);
            node.updateContent((CompoundBinaryTag)tag.entry.write(newValue));
            node.invalidate();
            return (T)(returnPrevious ? previousValue2 : newValue);
        }
        StaticIntMap<Entry<?>> entries = node.entries;
        int tagIndex = tag.index;
        Entry<?> previousEntry = entries.get(tagIndex);
        if (previousEntry != null) {
            Object previousTmp = previousEntry.value;
            if (previousTmp instanceof Node) {
                Node n = (Node)previousTmp;
                CompoundBinaryTag compound = CompoundBinaryTag.from(Map.of(tag.getKey(), n.compound()));
                previousValue = tag.read(compound);
            } else {
                previousValue = previousTmp;
            }
        } else {
            previousValue = tag.createDefault();
        }
        Object newValue = value.apply(previousValue);
        if (newValue != null) {
            entries.put(tagIndex, this.valueToEntry(node, tag, newValue));
        } else {
            entries.remove(tagIndex);
        }
        node.invalidate();
        return (T)(returnPrevious ? previousValue : newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TagReadable readableCopy() {
        Node copy = this.copy;
        if (copy == null) {
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                this.copy = copy = this.root.copy(null);
            }
        }
        return copy;
    }

    @Override
    @NotNull
    public synchronized TagHandler copy() {
        return new TagHandlerImpl(this.root.copy(null));
    }

    @Override
    public synchronized void updateContent(@NotNull CompoundBinaryTag compound) {
        this.root.updateContent(compound);
    }

    @Override
    @NotNull
    public CompoundBinaryTag asCompound() {
        VarHandle.fullFence();
        return this.root.compound();
    }

    private static Node traversePathRead(Node node, Tag<?> tag) {
        Tag.PathEntry[] paths = tag.path;
        if (paths == null) {
            return node;
        }
        for (Tag.PathEntry path : paths) {
            Entry<?> entry = node.entries.get(path.index());
            if (entry != null && (node = entry.toNode()) != null) continue;
            return null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, _, true -> !null")
    private Node traversePathWrite(Node root, Tag<?> tag, boolean present) {
        Tag.PathEntry[] paths = tag.path;
        if (paths == null) {
            return root;
        }
        Node local = root;
        for (Tag.PathEntry path : paths) {
            int pathIndex = path.index();
            Entry<?> entry = local.entries.get(pathIndex);
            if (entry != null && entry.tag.entry.isPath()) {
                Node tmp = (Node)entry.value;
                assert (tmp.parent == local) : "Path parent is invalid: " + String.valueOf(tmp.parent) + " != " + String.valueOf(local);
                local = tmp;
                continue;
            }
            if (!present) {
                return null;
            }
            TagHandlerImpl tagHandlerImpl = this;
            synchronized (tagHandlerImpl) {
                BinaryTag binaryTag;
                Node tmp;
                Entry<?> synEntry = local.entries.get(pathIndex);
                if (synEntry != null && synEntry.tag.entry.isPath()) {
                    tmp = (Node)synEntry.value;
                    assert (tmp.parent == local) : "Path parent is invalid: " + String.valueOf(tmp.parent) + " != " + String.valueOf(local);
                    local = tmp;
                    continue;
                }
                tmp = local;
                local = new Node(tmp);
                if (synEntry != null && (binaryTag = synEntry.updatedNbt()) instanceof CompoundBinaryTag) {
                    CompoundBinaryTag compound = (CompoundBinaryTag)binaryTag;
                    local.updateContent(compound);
                }
                tmp.entries.put(pathIndex, Entry.makePathEntry(path.name(), local));
            }
        }
        return local;
    }

    private <T> Entry<?> valueToEntry(Node parent, Tag<T> tag, @NotNull T value) {
        if (value instanceof BinaryTag) {
            BinaryTag nbt = (BinaryTag)value;
            if (nbt instanceof CompoundBinaryTag) {
                CompoundBinaryTag compound = (CompoundBinaryTag)nbt;
                TagHandlerImpl handler = TagHandlerImpl.fromCompound(compound);
                return Entry.makePathEntry(tag, new Node(parent, handler.root.entries));
            }
            TagNbtSeparator.Entry nbtEntry = TagNbtSeparator.separateSingle(tag.getKey(), nbt);
            return new Entry(nbtEntry.tag(), nbtEntry.value());
        }
        return new Entry<T>(tag, tag.copyValue(value));
    }

    final class Node
    implements TagReadable {
        final Node parent;
        final StaticIntMap<Entry<?>> entries;
        CompoundBinaryTag compound;

        public Node(Node parent, StaticIntMap<Entry<?>> entries) {
            this.parent = parent;
            this.entries = entries;
        }

        Node(Node parent) {
            this(parent, new StaticIntMap.Array());
        }

        Node() {
            this(null);
        }

        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            Node node = TagHandlerImpl.traversePathRead(this, tag);
            if (node == null) {
                return tag.createDefault();
            }
            if (tag.isView()) {
                return tag.read(node.compound());
            }
            StaticIntMap<Entry<?>> entries = node.entries;
            Entry<?> entry = entries.get(tag.index);
            if (entry == null) {
                return tag.createDefault();
            }
            if (entry.tag.shareValue(tag)) {
                return entry.value;
            }
            BinaryTag nbt = entry.updatedNbt();
            Serializers.Entry serializerEntry = tag.entry;
            BinaryTagType<BinaryTag> type = serializerEntry.nbtType();
            return type == null || type.equals((Object)nbt.type()) ? serializerEntry.read(nbt) : tag.createDefault();
        }

        void updateContent(@NotNull CompoundBinaryTag compound) {
            TagHandlerImpl converted = TagHandlerImpl.fromCompound(compound);
            this.entries.updateContent(converted.root.entries);
            this.compound = compound;
        }

        CompoundBinaryTag compound() {
            CompoundBinaryTag compound;
            if (!ServerFlag.TAG_HANDLER_CACHE_ENABLED || (compound = this.compound) == null) {
                CompoundBinaryTag.Builder tmp = CompoundBinaryTag.builder();
                this.entries.forValues(entry -> {
                    Tag tag = entry.tag;
                    BinaryTag nbt = entry.updatedNbt();
                    if (nbt != null && (!tag.entry.isPath() || !ServerFlag.SERIALIZE_EMPTY_COMPOUND && ((CompoundBinaryTag)nbt).size() > 0)) {
                        tmp.put(tag.getKey(), nbt);
                    }
                });
                this.compound = compound = tmp.build();
            }
            return compound;
        }

        @Contract(value="null -> !null")
        Node copy(Node parent) {
            CompoundBinaryTag.Builder tmp = CompoundBinaryTag.builder();
            Node result = new Node(parent, new StaticIntMap.Array());
            StaticIntMap<Entry<?>> entries = result.entries;
            this.entries.forValues(entry -> {
                BinaryTag nbt;
                Tag tag = entry.tag;
                Object value = entry.value;
                if (value instanceof Node) {
                    Node node = (Node)value;
                    Node copy = node.copy(result);
                    if (copy == null) {
                        return;
                    }
                    value = copy;
                    nbt = copy.compound;
                    assert (nbt != null) : "Node copy should also compute the compound";
                } else {
                    nbt = entry.updatedNbt();
                }
                if (nbt != null) {
                    tmp.put(tag.getKey(), nbt);
                }
                entries.put(tag.index, TagHandlerImpl.this.valueToEntry(result, tag, value));
            });
            CompoundBinaryTag compound = tmp.build();
            if (!ServerFlag.SERIALIZE_EMPTY_COMPOUND && compound.size() == 0 && parent != null) {
                return null;
            }
            result.compound = compound;
            return result;
        }

        void invalidate() {
            Node tmp = this;
            do {
                tmp.compound = null;
            } while ((tmp = tmp.parent) != null);
            TagHandlerImpl.this.copy = null;
        }
    }

    private static final class Entry<T> {
        private final Tag<T> tag;
        T value;
        BinaryTag nbt;

        Entry(Tag<T> tag, T value) {
            this.tag = tag;
            this.value = value;
        }

        static Entry<?> makePathEntry(String path, Node node) {
            return new Entry<Node>(Tag.tag(path, NODE_SERIALIZER), node);
        }

        static Entry<?> makePathEntry(Tag<?> tag, Node node) {
            return Entry.makePathEntry(tag.getKey(), node);
        }

        BinaryTag updatedNbt() {
            if (this.tag.entry.isPath()) {
                return ((Node)this.value).compound();
            }
            BinaryTag nbt = this.nbt;
            if (nbt == null) {
                this.nbt = nbt = this.tag.entry.write(this.value);
            }
            return nbt;
        }

        void updateValue(T value) {
            assert (!this.tag.entry.isPath());
            this.value = value;
            this.nbt = null;
        }

        Node toNode() {
            if (this.tag.entry.isPath()) {
                return (Node)this.value;
            }
            BinaryTag binaryTag = this.updatedNbt();
            if (binaryTag instanceof CompoundBinaryTag) {
                CompoundBinaryTag compound = (CompoundBinaryTag)binaryTag;
                return TagHandlerImpl.fromCompound((CompoundBinaryTag)compound).root;
            }
            return null;
        }
    }
}

