/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Collection;
import java.util.Set;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ObjectSetImpl;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public sealed interface ObjectSet<T extends ProtocolObject>
permits ObjectSetImpl {
    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> empty() {
        return ObjectSetImpl.Empty.INSTANCE;
    }

    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> of(@NotNull Collection<NamespaceID> entries) {
        return new ObjectSetImpl.Entries(Set.copyOf(entries));
    }

    @NotNull
    public static <T extends ProtocolObject> ObjectSet<T> of(@NotNull Tag tag) {
        return new ObjectSetImpl.Tag(tag);
    }

    @NotNull
    public static <T extends ProtocolObject> BinaryTagSerializer<ObjectSet<T>> nbtType(@NotNull Tag.BasicType tagType) {
        return new ObjectSetImpl.NbtType(tagType);
    }

    default public boolean contains(@NotNull StaticProtocolObject object) {
        return this.contains(object.namespace());
    }

    default public boolean contains(@NotNull DynamicRegistry.Key<T> key) {
        return this.contains(key.namespace());
    }

    public boolean contains(@NotNull NamespaceID var1);
}

