/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.recipe.BlastingRecipe;
import net.minestom.server.recipe.CampfireCookingRecipe;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeConversion;
import net.minestom.server.recipe.RecipeType;
import net.minestom.server.recipe.ShapedRecipe;
import net.minestom.server.recipe.ShapelessRecipe;
import net.minestom.server.recipe.SmeltingRecipe;
import net.minestom.server.recipe.SmithingTransformRecipe;
import net.minestom.server.recipe.SmithingTrimRecipe;
import net.minestom.server.recipe.SmokingRecipe;
import net.minestom.server.recipe.StonecutterRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeManager {
    private final CachedPacket declareRecipesPacket = new CachedPacket(this::createDeclareRecipesPacket);
    private final Set<Recipe> recipes = new CopyOnWriteArraySet<Recipe>();

    public void addRecipes(Recipe ... recipe) {
        if (this.recipes.addAll(List.of(recipe))) {
            this.declareRecipesPacket.invalidate();
        }
    }

    public void addRecipe(@NotNull Recipe recipe) {
        if (this.recipes.add(recipe)) {
            this.declareRecipesPacket.invalidate();
        }
    }

    public void removeRecipe(@NotNull Recipe recipe) {
        if (this.recipes.remove(recipe)) {
            this.declareRecipesPacket.invalidate();
        }
    }

    @NotNull
    public Set<Recipe> getRecipes() {
        return this.recipes;
    }

    @NotNull
    public SendablePacket getDeclareRecipesPacket() {
        return this.declareRecipesPacket;
    }

    @NotNull
    private DeclareRecipesPacket createDeclareRecipesPacket() {
        ArrayList<DeclareRecipesPacket.DeclaredRecipe> entries = new ArrayList<DeclareRecipesPacket.DeclaredRecipe>();
        for (Recipe recipe : this.recipes) {
            entries.add((DeclareRecipesPacket.DeclaredRecipe)((Object)(switch (recipe.type) {
                case RecipeType.SHAPELESS -> RecipeConversion.shapeless((ShapelessRecipe)recipe);
                case RecipeType.SHAPED -> RecipeConversion.shaped((ShapedRecipe)recipe);
                case RecipeType.SMELTING -> RecipeConversion.smelting((SmeltingRecipe)recipe);
                case RecipeType.BLASTING -> RecipeConversion.blasting((BlastingRecipe)recipe);
                case RecipeType.SMOKING -> RecipeConversion.smoking((SmokingRecipe)recipe);
                case RecipeType.CAMPFIRE_COOKING -> RecipeConversion.campfire((CampfireCookingRecipe)recipe);
                case RecipeType.STONECUTTING -> RecipeConversion.stonecutter((StonecutterRecipe)recipe);
                case RecipeType.SMITHING_TRANSFORM -> RecipeConversion.smithingTransform((SmithingTransformRecipe)recipe);
                case RecipeType.SMITHING_TRIM -> RecipeConversion.smithingTrim((SmithingTrimRecipe)recipe);
                default -> throw new IllegalStateException("Unhandled recipe type : " + String.valueOf(recipe.type));
            })));
        }
        return new DeclareRecipesPacket(entries);
    }
}

