/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.potion;

import java.util.Objects;
import net.minestom.server.entity.Entity;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.EntityEffectPacket;
import net.minestom.server.network.packet.server.play.RemoveEntityEffectPacket;
import net.minestom.server.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public record Potion(@NotNull PotionEffect effect, byte amplifier, int duration, byte flags) implements NetworkBuffer.Writer
{
    public static final byte AMBIENT_FLAG = 1;
    public static final byte PARTICLES_FLAG = 2;
    public static final byte ICON_FLAG = 4;
    public static final byte BLEND_FLAG = 8;
    public static final int INFINITE_DURATION = -1;

    public Potion(@NotNull PotionEffect effect, byte amplifier, int duration, int flags) {
        this(effect, amplifier, duration, (byte)flags);
    }

    public Potion(@NotNull PotionEffect effect, byte amplifier, int duration) {
        this(effect, amplifier, duration, 0);
    }

    public Potion(@NotNull NetworkBuffer reader) {
        this(Objects.requireNonNull(PotionEffect.fromId(reader.read(NetworkBuffer.VAR_INT))), (byte)reader.read(NetworkBuffer.BYTE), (int)reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BYTE));
    }

    public boolean isAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean hasParticles() {
        return (this.flags & 2) == 2;
    }

    public boolean hasIcon() {
        return (this.flags & 4) == 4;
    }

    public boolean hasBlend() {
        return (this.flags & 8) == 8;
    }

    public void sendAddPacket(@NotNull Entity entity) {
        entity.sendPacketToViewersAndSelf(new EntityEffectPacket(entity.getEntityId(), this));
    }

    public void sendRemovePacket(@NotNull Entity entity) {
        entity.sendPacketToViewersAndSelf(new RemoveEntityEffectPacket(entity.getEntityId(), this.effect));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.effect.id());
        writer.write(NetworkBuffer.BYTE, this.amplifier);
        writer.write(NetworkBuffer.VAR_INT, this.duration);
        writer.write(NetworkBuffer.BYTE, this.flags);
    }
}

