/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record TradeListPacket(int windowId, @NotNull List<Trade> trades, int villagerLevel, int experience, boolean regularVillager, boolean canRestock) implements ServerPacket.Play
{
    public static final int MAX_TRADES = Short.MAX_VALUE;

    public TradeListPacket(int windowId, @NotNull List<Trade> trades, int villagerLevel, int experience, boolean regularVillager, boolean canRestock) {
        trades = List.copyOf(trades);
    }

    public TradeListPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(Trade::new, Short.MAX_VALUE), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.windowId);
        writer.writeCollection(this.trades);
        writer.write(NetworkBuffer.VAR_INT, this.villagerLevel);
        writer.write(NetworkBuffer.VAR_INT, this.experience);
        writer.write(NetworkBuffer.BOOLEAN, this.regularVillager);
        writer.write(NetworkBuffer.BOOLEAN, this.canRestock);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.TRADE_LIST;
    }

    public record Trade(ItemStack inputItem1, ItemStack result, ItemStack inputItem2, boolean tradeDisabled, int tradeUsesNumber, int maxTradeUsesNumber, int exp, int specialPrice, float priceMultiplier, int demand) implements NetworkBuffer.Writer
    {
        public Trade(@NotNull NetworkBuffer reader) {
            this(reader.read(ItemStack.NETWORK_TYPE), reader.read(ItemStack.NETWORK_TYPE), reader.readOptional(ItemStack.NETWORK_TYPE), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(ItemStack.NETWORK_TYPE, this.inputItem1);
            writer.write(ItemStack.NETWORK_TYPE, this.result);
            writer.writeOptional(ItemStack.NETWORK_TYPE, this.inputItem2);
            writer.write(NetworkBuffer.BOOLEAN, this.tradeDisabled);
            writer.write(NetworkBuffer.INT, this.tradeUsesNumber);
            writer.write(NetworkBuffer.INT, this.maxTradeUsesNumber);
            writer.write(NetworkBuffer.INT, this.exp);
            writer.write(NetworkBuffer.INT, this.specialPrice);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.priceMultiplier));
            writer.write(NetworkBuffer.INT, this.demand);
        }
    }
}

