/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.advancements.AdvancementAction;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClientAdvancementTabPacket(@NotNull AdvancementAction action, @Nullable String tabIdentifier) implements ClientPacket
{
    public ClientAdvancementTabPacket(@NotNull AdvancementAction action, @Nullable String tabIdentifier) {
        if (tabIdentifier != null && tabIdentifier.length() > 256) {
            throw new IllegalArgumentException("Tab identifier too long: " + tabIdentifier.length());
        }
    }

    public ClientAdvancementTabPacket(@NotNull NetworkBuffer reader) {
        this(ClientAdvancementTabPacket.read(reader));
    }

    private ClientAdvancementTabPacket(ClientAdvancementTabPacket packet) {
        this(packet.action, packet.tabIdentifier);
    }

    private static ClientAdvancementTabPacket read(@NotNull NetworkBuffer reader) {
        AdvancementAction action = reader.readEnum(AdvancementAction.class);
        String tabIdentifier = action == AdvancementAction.OPENED_TAB ? reader.read(NetworkBuffer.STRING) : null;
        return new ClientAdvancementTabPacket(action, tabIdentifier);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeEnum(AdvancementAction.class, this.action);
        if (this.action == AdvancementAction.OPENED_TAB) {
            assert (this.tabIdentifier != null);
            if (this.tabIdentifier.length() > 256) {
                throw new IllegalArgumentException("Tab identifier cannot be longer than 256 characters.");
            }
            writer.write(NetworkBuffer.STRING, this.tabIdentifier);
        }
    }
}

