/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.format.Style;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record ChatTypeDecoration(@NotNull String translationKey, @NotNull List<Parameter> parameters, @NotNull Style style) {
    public static final BinaryTagSerializer<ChatTypeDecoration> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        String translationKey = tag.getString("translation_key");
        List<Parameter> parameters = Parameter.LIST_NBT_TYPE.read((BinaryTag)tag.getList("parameters"));
        Style style = Style.empty();
        BinaryTag patt0$temp = tag.get("style");
        if (patt0$temp instanceof CompoundBinaryTag) {
            CompoundBinaryTag styleTag = (CompoundBinaryTag)patt0$temp;
            style = BinaryTagSerializer.NBT_COMPONENT_STYLE.read((BinaryTag)styleTag);
        }
        return new ChatTypeDecoration(translationKey, parameters, style);
    }, deco -> {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        builder.putString("translation_key", deco.translationKey());
        builder.put("parameters", Parameter.LIST_NBT_TYPE.write(deco.parameters()));
        if (!deco.style.isEmpty()) {
            builder.put("style", BinaryTagSerializer.NBT_COMPONENT_STYLE.write(deco.style()));
        }
        return builder.build();
    });

    public static enum Parameter {
        SENDER,
        TARGET,
        CONTENT;

        public static final BinaryTagSerializer<Parameter> NBT_TYPE;
        private static final BinaryTagSerializer<List<Parameter>> LIST_NBT_TYPE;

        static {
            NBT_TYPE = BinaryTagSerializer.fromEnumStringable(Parameter.class);
            LIST_NBT_TYPE = NBT_TYPE.list();
        }
    }
}

