/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public non-sealed interface EntityEffect
extends Enchantment.Effect {
    @NotNull
    public static final BinaryTagSerializer<EntityEffect> NBT_TYPE = BinaryTagSerializer.registryTaggedUnion(Registries::enchantmentEntityEffects, EntityEffect::nbtType, "type");

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<BinaryTagSerializer<? extends EntityEffect>> createDefaultRegistry() {
        DynamicRegistry<BinaryTagSerializer<? extends EntityEffect>> registry = DynamicRegistry.create("minestom:enchantment_value_effect");
        registry.register("all_of", AllOf.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("apply_mob_effect", ApplyPotionEffect.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("damage_entity", DamageEntity.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("damage_item", DamageItem.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("explode", Explode.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("ignite", Ignite.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("play_sound", PlaySound.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("replace_block", ReplaceBlock.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("replace_disk", ReplaceDisc.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("run_function", RunFunction.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("set_block_properties", SetBlockProperties.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("spawn_particles", SpawnParticles.NBT_TYPE, DataPack.MINECRAFT_CORE);
        registry.register("summon_entity", SummonEntity.NBT_TYPE, DataPack.MINECRAFT_CORE);
        return registry;
    }

    @NotNull
    public BinaryTagSerializer<? extends EntityEffect> nbtType();

    public record AllOf(@NotNull List<EntityEffect> effect) implements EntityEffect
    {
        public static final BinaryTagSerializer<AllOf> NBT_TYPE = BinaryTagSerializer.object("effects", NBT_TYPE.list(), AllOf::effect, AllOf::new);

        public AllOf(@NotNull List<EntityEffect> effect) {
            effect = List.copyOf(effect);
        }

        @NotNull
        public BinaryTagSerializer<AllOf> nbtType() {
            return NBT_TYPE;
        }
    }

    public record ApplyPotionEffect(@NotNull ObjectSet<PotionEffect> toApply, @NotNull LevelBasedValue minDuration, @NotNull LevelBasedValue maxDuration, @NotNull LevelBasedValue minAmplifier, @NotNull LevelBasedValue maxAmplifier) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<ApplyPotionEffect> NBT_TYPE = BinaryTagSerializer.object("to_apply", ObjectSet.nbtType(Tag.BasicType.POTION_EFFECTS), ApplyPotionEffect::toApply, "min_duration", LevelBasedValue.NBT_TYPE, ApplyPotionEffect::minDuration, "max_duration", LevelBasedValue.NBT_TYPE, ApplyPotionEffect::maxDuration, "min_amplifier", LevelBasedValue.NBT_TYPE, ApplyPotionEffect::minAmplifier, "max_amplifier", LevelBasedValue.NBT_TYPE, ApplyPotionEffect::maxAmplifier, ApplyPotionEffect::new);

        @NotNull
        public BinaryTagSerializer<ApplyPotionEffect> nbtType() {
            return NBT_TYPE;
        }
    }

    public record DamageEntity(@NotNull DynamicRegistry.Key<DamageType> damageType, @NotNull LevelBasedValue minDamage, @NotNull LevelBasedValue maxDamage) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<DamageEntity> NBT_TYPE = BinaryTagSerializer.object("damage_type", DamageType.NBT_TYPE, DamageEntity::damageType, "min_damage", LevelBasedValue.NBT_TYPE, DamageEntity::minDamage, "max_damage", LevelBasedValue.NBT_TYPE, DamageEntity::maxDamage, DamageEntity::new);

        @NotNull
        public BinaryTagSerializer<DamageEntity> nbtType() {
            return NBT_TYPE;
        }
    }

    public record DamageItem(@NotNull LevelBasedValue amount) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<DamageItem> NBT_TYPE = BinaryTagSerializer.object("amount", LevelBasedValue.NBT_TYPE, DamageItem::amount, DamageItem::new);

        @NotNull
        public BinaryTagSerializer<DamageItem> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Explode(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<Explode> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(Explode::new, Explode::content);

        @NotNull
        public BinaryTagSerializer<Explode> nbtType() {
            return NBT_TYPE;
        }
    }

    public record Ignite(@NotNull LevelBasedValue duration) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<Ignite> NBT_TYPE = BinaryTagSerializer.object("duration", LevelBasedValue.NBT_TYPE, Ignite::duration, Ignite::new);

        @NotNull
        public BinaryTagSerializer<Ignite> nbtType() {
            return NBT_TYPE;
        }
    }

    public record PlaySound(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<PlaySound> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(PlaySound::new, PlaySound::content);

        @NotNull
        public BinaryTagSerializer<PlaySound> nbtType() {
            return NBT_TYPE;
        }
    }

    public record ReplaceBlock(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<ReplaceBlock> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(ReplaceBlock::new, ReplaceBlock::content);

        @NotNull
        public BinaryTagSerializer<ReplaceBlock> nbtType() {
            return NBT_TYPE;
        }
    }

    public record ReplaceDisc(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<ReplaceDisc> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(ReplaceDisc::new, ReplaceDisc::content);

        @NotNull
        public BinaryTagSerializer<ReplaceDisc> nbtType() {
            return NBT_TYPE;
        }
    }

    public record RunFunction(@NotNull String function) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<RunFunction> NBT_TYPE = BinaryTagSerializer.object("function", BinaryTagSerializer.STRING, RunFunction::function, RunFunction::new);

        @NotNull
        public BinaryTagSerializer<RunFunction> nbtType() {
            return NBT_TYPE;
        }
    }

    public record SetBlockProperties(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<SetBlockProperties> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(SetBlockProperties::new, SetBlockProperties::content);

        @NotNull
        public BinaryTagSerializer<SetBlockProperties> nbtType() {
            return NBT_TYPE;
        }
    }

    public record SpawnParticles(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<SpawnParticles> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(SpawnParticles::new, SpawnParticles::content);

        @NotNull
        public BinaryTagSerializer<SpawnParticles> nbtType() {
            return NBT_TYPE;
        }
    }

    public record SummonEntity(CompoundBinaryTag content) implements EntityEffect,
    LocationEffect
    {
        public static final BinaryTagSerializer<SummonEntity> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(SummonEntity::new, SummonEntity::content);

        @NotNull
        public BinaryTagSerializer<SummonEntity> nbtType() {
            return NBT_TYPE;
        }
    }
}

