/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record AttributeList(@NotNull List<Modifier> modifiers, boolean showInTooltip) {
    public static final AttributeList EMPTY = new AttributeList(List.of(), true);
    public static final NetworkBuffer.Type<AttributeList> NETWORK_TYPE = new NetworkBuffer.Type<AttributeList>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, AttributeList value) {
            buffer.writeCollection(Modifier.NETWORK_TYPE, value.modifiers);
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        public AttributeList read(@NotNull NetworkBuffer buffer) {
            return new AttributeList(buffer.readCollection(Modifier.NETWORK_TYPE, Short.MAX_VALUE), (boolean)buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<AttributeList> NBT_TYPE = new BinaryTagSerializer<AttributeList>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull AttributeList value) {
            ListBinaryTag.Builder modifiers = ListBinaryTag.builder();
            for (Modifier modifier : value.modifiers) {
                modifiers.add(Modifier.NBT_TYPE.write(modifier));
            }
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("modifiers", (BinaryTag)modifiers.build())).putBoolean("show_in_tooltip", value.showInTooltip)).build();
        }

        @Override
        @NotNull
        public AttributeList read(@NotNull BinaryTag tag) {
            BinaryTag binaryTag = tag;
            Objects.requireNonNull(binaryTag);
            BinaryTag binaryTag2 = binaryTag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundBinaryTag.class, ListBinaryTag.class}, (Object)binaryTag2, n)) {
                case 0 -> {
                    CompoundBinaryTag compound = (CompoundBinaryTag)binaryTag2;
                    yield new AttributeList(compound.getList("modifiers", BinaryTagTypes.COMPOUND).stream().map(Modifier.NBT_TYPE::read).toList(), compound.getBoolean("show_in_tooltip", true));
                }
                case 1 -> {
                    ListBinaryTag list = (ListBinaryTag)binaryTag2;
                    yield new AttributeList(list.stream().map(Modifier.NBT_TYPE::read).toList());
                }
                default -> EMPTY;
            };
        }
    };

    public AttributeList(@NotNull List<Modifier> modifiers, boolean showInTooltip) {
        modifiers = List.copyOf(modifiers);
    }

    public AttributeList(@NotNull List<Modifier> modifiers) {
        this(modifiers, true);
    }

    public AttributeList(@NotNull Modifier modifier, boolean showInTooltip) {
        this(List.of(modifier), showInTooltip);
    }

    public AttributeList(@NotNull Modifier modifier) {
        this(modifier, true);
    }

    @NotNull
    public AttributeList with(@NotNull Modifier modifier) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(this.modifiers);
        newModifiers.add(modifier);
        return new AttributeList(newModifiers, this.showInTooltip);
    }

    @NotNull
    public AttributeList withTooltip(boolean showInTooltip) {
        return new AttributeList(this.modifiers, showInTooltip);
    }

    public record Modifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull EquipmentSlotGroup slot) {
        public static final NetworkBuffer.Type<Modifier> NETWORK_TYPE = new NetworkBuffer.Type<Modifier>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Modifier value) {
                buffer.write(Attribute.NETWORK_TYPE, value.attribute);
                buffer.write(AttributeModifier.NETWORK_TYPE, value.modifier);
                buffer.writeEnum(EquipmentSlotGroup.class, value.slot);
            }

            @Override
            public Modifier read(@NotNull NetworkBuffer buffer) {
                return new Modifier(buffer.read(Attribute.NETWORK_TYPE), buffer.read(AttributeModifier.NETWORK_TYPE), buffer.readEnum(EquipmentSlotGroup.class));
            }
        };
        public static final BinaryTagSerializer<Modifier> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
            EquipmentSlotGroup equipmentSlotGroup;
            BinaryTag patt0$temp = tag.get("slot");
            if (patt0$temp instanceof BinaryTag) {
                BinaryTag slot = patt0$temp;
                equipmentSlotGroup = EquipmentSlotGroup.NBT_TYPE.read(slot);
            } else {
                equipmentSlotGroup = EquipmentSlotGroup.ANY;
            }
            return new Modifier(Attribute.NBT_TYPE.read(tag.get("type")), AttributeModifier.NBT_TYPE.read((BinaryTag)tag), equipmentSlotGroup);
        }, modifier -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("type", Attribute.NBT_TYPE.write(modifier.attribute))).put((CompoundBinaryTag)AttributeModifier.NBT_TYPE.write(modifier.modifier))).put("slot", EquipmentSlotGroup.NBT_TYPE.write(modifier.slot))).build());
    }
}

