/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.Arrays;
import java.util.Objects;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.BlockLight;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;

public final class LightCompute {
    static final Direction[] DIRECTIONS = Direction.values();
    static final int LIGHT_LENGTH = 2048;
    static final int SECTION_SIZE = 16;
    public static final byte[] emptyContent = new byte[2048];
    public static final byte[] contentFullyLit = new byte[2048];

    @NotNull
    static Result compute(Palette blockPalette) {
        return LightCompute.compute(blockPalette, BlockLight.buildInternalQueue(blockPalette));
    }

    @NotNull
    static Result compute(Palette blockPalette, ShortArrayFIFOQueue lightPre) {
        short index;
        if (lightPre.isEmpty()) {
            return new Result(emptyContent);
        }
        byte[] lightArray = new byte[2048];
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        while (!lightPre.isEmpty()) {
            index = lightPre.dequeueShort();
            int newLightLevel = index >> 12 & 0xF;
            int newIndex = index & 0xFFF;
            int oldLightLevel = LightCompute.getLight(lightArray, newIndex);
            if (oldLightLevel >= newLightLevel) continue;
            LightCompute.placeLight(lightArray, newIndex, newLightLevel);
            lightSources.enqueue(index);
        }
        while (!lightSources.isEmpty()) {
            index = lightSources.dequeueShort();
            int x = index & 0xF;
            int z = index >> 4 & 0xF;
            int y = index >> 8 & 0xF;
            int lightLevel = index >> 12 & 0xF;
            byte newLightLevel = (byte)(lightLevel - 1);
            for (Direction direction : DIRECTIONS) {
                boolean airAir;
                int newIndex;
                int xO = x + direction.normalX();
                int yO = y + direction.normalY();
                int zO = z + direction.normalZ();
                if (xO < 0 || xO >= 16 || yO < 0 || yO >= 16 || zO < 0 || zO >= 16 || LightCompute.getLight(lightArray, newIndex = xO | zO << 4 | yO << 8) >= newLightLevel) continue;
                Block currentBlock = Objects.requireNonNullElse(Block.fromStateId((short)blockPalette.get(x, y, z)), Block.AIR);
                Block propagatedBlock = Objects.requireNonNullElse(Block.fromStateId((short)blockPalette.get(xO, yO, zO)), Block.AIR);
                boolean bl = airAir = currentBlock.isAir() && propagatedBlock.isAir();
                if (!airAir && currentBlock.registry().collisionShape().isOccluded(propagatedBlock.registry().collisionShape(), BlockFace.fromDirection(direction))) continue;
                LightCompute.placeLight(lightArray, newIndex, newLightLevel);
                lightSources.enqueue((short)(newIndex | newLightLevel << 12));
            }
        }
        return new Result(lightArray);
    }

    private static void placeLight(byte[] light, int index, int value) {
        int shift = (index & 1) << 2;
        int i = index >>> 1;
        light[i] = (byte)(light[i] & 240 >>> shift | value << shift);
    }

    static int getLight(byte[] light, int index) {
        if (index >>> 1 >= light.length) {
            return 0;
        }
        byte value = light[index >>> 1];
        return value >>> ((index & 1) << 2) & 0xF;
    }

    static {
        Arrays.fill(contentFullyLit, (byte)-1);
    }

    record Result(byte[] light) {
        Result {
            assert (light.length == 2048) : "Only 16x16x16 sections are supported: " + light.length;
        }

        public byte getLight(int x, int y, int z) {
            return (byte)LightCompute.getLight(this.light, x | z << 4 | y << 8);
        }
    }
}

