/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;

public class WaterNodeGenerator
implements NodeGenerator {
    private PNode tempNode = null;
    private final BoundingBox.PointIterator pointIterator = new BoundingBox.PointIterator();

    @Override
    @NotNull
    public Collection<? extends PNode> getWalkable(@NotNull Instance instance, @NotNull Set<PNode> visited, @NotNull PNode current, @NotNull Point goal, @NotNull BoundingBox boundingBox) {
        PNode nodeFall;
        PNode nodeJump;
        ArrayList<PNode> nearby = new ArrayList<PNode>();
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, current);
        int stepSize = (int)Math.max(Math.floor(boundingBox.width() / 2.0), 1.0);
        if (stepSize < 1) {
            stepSize = 1;
        }
        for (int x = -stepSize; x <= stepSize; ++x) {
            for (int z = -stepSize; z <= stepSize; ++z) {
                PNode nodeFall2;
                PNode nodeJump2;
                PNode nodeWalk;
                if (x == 0 && z == 0) continue;
                double cost = Math.sqrt(x * x + z * z) * 0.98;
                double currentLevelPointX = (double)current.blockX() + 0.5 + (double)x;
                double currentLevelPointY = current.blockY();
                double currentLevelPointZ = (double)current.blockZ() + 0.5 + (double)z;
                double upPointX = (double)current.blockX() + 0.5 + (double)x;
                double upPointY = (double)(current.blockY() + 1) + 0.5;
                double upPointZ = (double)current.blockZ() + 0.5 + (double)z;
                double downPointX = (double)current.blockX() + 0.5 + (double)x;
                double downPointY = (double)(current.blockY() - 1) + 0.5;
                double downPointZ = (double)current.blockZ() + 0.5 + (double)z;
                if (instance.getBlock((int)Math.floor(currentLevelPointX), (int)Math.floor(currentLevelPointY), (int)Math.floor(currentLevelPointZ)).compare(Block.WATER) && (nodeWalk = this.createFly(instance, new Vec(currentLevelPointX, currentLevelPointY, currentLevelPointZ), boundingBox, cost, current, goal, visited)) != null && !visited.contains(nodeWalk)) {
                    nearby.add(nodeWalk);
                }
                if (instance.getBlock((int)Math.floor(upPointX), (int)Math.floor(upPointY), (int)Math.floor(upPointZ)).compare(Block.WATER) && (nodeJump2 = this.createFly(instance, new Vec(upPointX, upPointY, upPointZ), boundingBox, cost, current, goal, visited)) != null && !visited.contains(nodeJump2)) {
                    nearby.add(nodeJump2);
                }
                if (!instance.getBlock((int)Math.floor(downPointX), (int)Math.floor(downPointY), (int)Math.floor(downPointZ)).compare(Block.WATER) || (nodeFall2 = this.createFly(instance, new Vec(downPointX, downPointY, downPointZ), boundingBox, cost, current, goal, visited)) == null || visited.contains(nodeFall2)) continue;
                nearby.add(nodeFall2);
            }
        }
        double upPointX = current.x();
        double upPointY = (double)(current.blockY() + 1) + 0.5;
        double upPointZ = current.z();
        if (instance.getBlock((int)Math.floor(upPointX), (int)Math.floor(upPointY), (int)Math.floor(upPointZ)).compare(Block.WATER) && (nodeJump = this.createFly(instance, new Vec(current.x(), current.y(), current.z()), boundingBox, 2.0, current, goal, visited)) != null && !visited.contains(nodeJump)) {
            nearby.add(nodeJump);
        }
        double downPointX = current.x();
        double downPointY = (double)(current.blockY() - 1) + 0.5;
        double downPointZ = current.z();
        if (instance.getBlock((int)Math.floor(downPointX), (int)Math.floor(downPointY), (int)Math.floor(downPointZ)).compare(Block.WATER) && (nodeFall = this.createFly(instance, new Vec(downPointX, downPointY, downPointZ), boundingBox, 2.0, current, goal, visited)) != null && !visited.contains(nodeFall)) {
            nearby.add(nodeFall);
        }
        return nearby;
    }

    @Override
    public boolean hasGravitySnap() {
        return false;
    }

    private PNode createFly(Instance instance, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (!this.canMoveTowards(instance, new Vec(start.x(), start.y(), start.z()), point, boundingBox)) {
            return null;
        }
        n.setType(PNode.NodeType.FLY);
        return n;
    }

    private PNode newNode(PNode current, double cost, Point point, Point goal) {
        this.tempNode.setG(current.g() + cost);
        this.tempNode.setH(this.heuristic(point, goal));
        this.tempNode.setPoint(point.x(), point.y(), point.z());
        PNode newNode = this.tempNode;
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, PNode.NodeType.WALK, current);
        return newNode;
    }

    @Override
    @NotNull
    public OptionalDouble gravitySnap(@NotNull Instance instance, double pointOrgX, double pointOrgY, double pointOrgZ, @NotNull BoundingBox boundingBox, double maxFall) {
        double pointX = (double)((int)Math.floor(pointOrgX)) + 0.5;
        double pointY = (int)Math.floor(pointOrgY);
        double pointZ = (double)((int)Math.floor(pointOrgZ)) + 0.5;
        Chunk c = instance.getChunkAt(pointX, pointZ);
        if (c == null) {
            return OptionalDouble.of(pointY);
        }
        int axis = 1;
        while ((double)axis <= maxFall) {
            this.pointIterator.reset(boundingBox, pointX, pointY, pointZ, BoundingBox.AxisMask.Y, -axis);
            while (this.pointIterator.hasNext()) {
                BoundingBox.MutablePoint block = this.pointIterator.next();
                Block foundBlock = instance.getBlock(block.blockX(), block.blockY(), block.blockZ(), Block.Getter.Condition.TYPE);
                if (!foundBlock.isSolid() && !foundBlock.compare(Block.WATER)) continue;
                return OptionalDouble.of(block.blockY() + 1);
            }
            ++axis;
        }
        return OptionalDouble.empty();
    }
}

