/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.monster.BasePiglinMeta;
import org.jetbrains.annotations.NotNull;

public class PiglinMeta
extends BasePiglinMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 20;

    public PiglinMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isBaby() {
        return this.metadata.getIndex(17, false);
    }

    public void setBaby(boolean value) {
        if (this.isBaby() == value) {
            return;
        }
        this.consumeEntity(entity -> {
            BoundingBox bb = entity.getBoundingBox();
            if (value) {
                double width = bb.width() / 2.0;
                entity.setBoundingBox(width, bb.height() / 2.0, width);
            } else {
                double width = bb.width() * 2.0;
                entity.setBoundingBox(width, bb.height() * 2.0, width);
            }
        });
        this.metadata.setIndex(17, Metadata.Boolean(value));
    }

    public boolean isChargingCrossbow() {
        return this.metadata.getIndex(18, false);
    }

    public void setChargingCrossbow(boolean value) {
        this.metadata.setIndex(18, Metadata.Boolean(value));
    }

    public boolean isDancing() {
        return this.metadata.getIndex(19, false);
    }

    public void setDancing(boolean value) {
        this.metadata.setIndex(19, Metadata.Boolean(value));
    }
}

