/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import org.jetbrains.annotations.NotNull;

public class PandaMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 23;
    private static final byte SNEEZING_BIT = 2;
    private static final byte ROLLING_BIT = 4;
    private static final byte SITTING_BIT = 8;
    private static final byte ON_BACK_BIT = 16;

    public PandaMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public int getBreedTimer() {
        return this.metadata.getIndex(17, 0);
    }

    public void setBreedTimer(int value) {
        this.metadata.setIndex(17, Metadata.VarInt(value));
    }

    public int getSneezeTimer() {
        return this.metadata.getIndex(18, 0);
    }

    public void setSneezeTimer(int value) {
        this.metadata.setIndex(18, Metadata.VarInt(value));
    }

    public int getEatTimer() {
        return this.metadata.getIndex(19, 0);
    }

    public void setEatTimer(int value) {
        this.metadata.setIndex(19, Metadata.VarInt(value));
    }

    @NotNull
    public Gene getMainGene() {
        return Gene.VALUES[this.metadata.getIndex(20, (byte)0)];
    }

    public void setMainGene(@NotNull Gene value) {
        this.metadata.setIndex(20, Metadata.Byte((byte)value.ordinal()));
    }

    @NotNull
    public Gene getHiddenGene() {
        return Gene.VALUES[this.metadata.getIndex(21, (byte)0)];
    }

    public void setHiddenGene(@NotNull Gene value) {
        this.metadata.setIndex(21, Metadata.Byte((byte)value.ordinal()));
    }

    public boolean isSneezing() {
        return this.getMaskBit(22, (byte)2);
    }

    public void setSneezing(boolean value) {
        this.setMaskBit(22, (byte)2, value);
    }

    public boolean isRolling() {
        return this.getMaskBit(22, (byte)4);
    }

    public void setRolling(boolean value) {
        this.setMaskBit(22, (byte)4, value);
    }

    public boolean isSitting() {
        return this.getMaskBit(22, (byte)8);
    }

    public void setSitting(boolean value) {
        this.setMaskBit(22, (byte)8, value);
    }

    public boolean isOnBack() {
        return this.getMaskBit(22, (byte)16);
    }

    public void setOnBack(boolean value) {
        this.setMaskBit(22, (byte)16, value);
    }

    public static enum Gene {
        NORMAL,
        AGGRESSIVE,
        LAZY,
        WORRIED,
        PLAYFUL,
        WEAK,
        BROWN;

        private static final Gene[] VALUES;

        static {
            VALUES = Gene.values();
        }
    }
}

