/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.List;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public enum EquipmentSlotGroup {
    ANY(EquipmentSlot.values()),
    MAIN_HAND(EquipmentSlot.MAIN_HAND),
    OFF_HAND(EquipmentSlot.OFF_HAND),
    HAND(EquipmentSlot.MAIN_HAND, EquipmentSlot.OFF_HAND),
    FEET(EquipmentSlot.BOOTS),
    LEGS(EquipmentSlot.LEGGINGS),
    CHEST(EquipmentSlot.CHESTPLATE),
    HEAD(EquipmentSlot.HELMET),
    ARMOR(EquipmentSlot.CHESTPLATE, EquipmentSlot.LEGGINGS, EquipmentSlot.BOOTS, EquipmentSlot.HELMET),
    BODY(EquipmentSlot.CHESTPLATE, EquipmentSlot.LEGGINGS);

    public static final NetworkBuffer.Type<EquipmentSlotGroup> NETWORK_TYPE;
    public static final BinaryTagSerializer<EquipmentSlotGroup> NBT_TYPE;
    private final List<EquipmentSlot> equipmentSlots;

    private EquipmentSlotGroup(EquipmentSlot ... equipmentSlots) {
        this.equipmentSlots = List.of(equipmentSlots);
    }

    @NotNull
    public List<EquipmentSlot> equipmentSlots() {
        return this.equipmentSlots;
    }

    public boolean contains(@NotNull EquipmentSlot equipmentSlot) {
        return this.equipmentSlots.contains((Object)equipmentSlot);
    }

    static {
        NETWORK_TYPE = NetworkBuffer.Enum(EquipmentSlotGroup.class);
        NBT_TYPE = BinaryTagSerializer.fromEnumStringable(EquipmentSlotGroup.class);
    }
}

