/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.function.DoubleUnaryOperator;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.BlockFace;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record BlockVec(double x, double y, double z) implements Point
{
    public BlockVec {
        x = Math.floor(x);
        y = Math.floor(y);
        z = Math.floor(z);
    }

    public BlockVec(int x, int y, int z) {
        this((double)x, (double)y, (double)z);
    }

    public BlockVec(@NotNull Point point) {
        this(point.x(), point.y(), point.z());
    }

    @Override
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator operator) {
        return new Vec(operator.applyAsDouble(this.x), this.y, this.z);
    }

    @Override
    @NotNull
    public Point withX(double x) {
        return new Vec(x, this.y, this.z);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec withBlockX(int x) {
        return new BlockVec((double)x, this.y, this.z);
    }

    @Override
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator operator) {
        return new Vec(this.x, operator.applyAsDouble(this.y), this.z);
    }

    @Override
    @NotNull
    public Point withY(double y) {
        return new Vec(this.x, y, this.z);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec withBlockY(int y) {
        return new BlockVec(this.x, (double)y, this.z);
    }

    @Override
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator operator) {
        return new Vec(this.x, this.y, operator.applyAsDouble(this.z));
    }

    @Override
    @NotNull
    public Point withZ(double z) {
        return new Vec(this.x, this.y, z);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec withBlockZ(int z) {
        return new BlockVec(this.x, this.y, (double)z);
    }

    @Override
    @NotNull
    public Point add(double x, double y, double z) {
        return new Vec(this.x + x, this.y + y, this.z + z);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec add(int x, int y, int z) {
        return new BlockVec(this.x + (double)x, this.y + (double)y, this.z + (double)z);
    }

    @Override
    @NotNull
    public Point add(@NotNull Point point) {
        return new Vec(this.x + point.x(), this.y + point.y(), this.z + point.z());
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec add(@NotNull BlockVec blockVec) {
        return new BlockVec(this.x + blockVec.x(), this.y + blockVec.y(), this.z + blockVec.z());
    }

    @Override
    @NotNull
    public Point add(double value) {
        return this.add(value, value, value);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec add(int value) {
        return new BlockVec(this.x + (double)value, this.y + (double)value, this.z + (double)value);
    }

    @Override
    @NotNull
    public Point sub(double x, double y, double z) {
        return new Vec(this.x - x, this.y - y, this.z - z);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec sub(int x, int y, int z) {
        return new BlockVec(this.x - (double)x, this.y - (double)y, this.z - (double)z);
    }

    @Override
    @NotNull
    public Point sub(@NotNull Point point) {
        return this.sub(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec sub(@NotNull BlockVec blockVec) {
        return new BlockVec(this.x - blockVec.x(), this.y - blockVec.y(), this.z - blockVec.z());
    }

    @Override
    @NotNull
    public Point sub(double value) {
        return this.sub(value, value, value);
    }

    @Contract(pure=true)
    @NotNull
    public BlockVec sub(int value) {
        return new BlockVec(this.x - (double)value, this.y - (double)value, this.z - (double)value);
    }

    @Override
    @NotNull
    public Point mul(double x, double y, double z) {
        return new Vec(this.x * x, this.y * y, this.z * z);
    }

    @Override
    @NotNull
    public Point mul(@NotNull Point point) {
        return this.mul(point.x(), point.y(), point.z());
    }

    @Override
    @NotNull
    public Point mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    @NotNull
    public Point div(double x, double y, double z) {
        return new Vec(this.x / x, this.y / y, this.z / z);
    }

    @Override
    @NotNull
    public Point div(@NotNull Point point) {
        return this.div(point.x(), point.y(), point.z());
    }

    @Override
    @NotNull
    public Point div(double value) {
        return this.div(value, value, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public BlockVec relative(@NotNull BlockFace face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case BlockFace.BOTTOM -> this.sub(0, 1, 0);
            case BlockFace.TOP -> this.add(0, 1, 0);
            case BlockFace.NORTH -> this.sub(0, 0, 1);
            case BlockFace.SOUTH -> this.add(0, 0, 1);
            case BlockFace.WEST -> this.sub(1, 0, 0);
            case BlockFace.EAST -> this.add(1, 0, 0);
        };
    }

    @Contract(pure=true)
    @NotNull
    public Vec asVec() {
        return new Vec(this.x, this.y, this.z);
    }
}

