/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.condition;

import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ConsoleSender;
import net.minestom.server.command.builder.condition.CommandCondition;
import net.minestom.server.entity.Player;

public class Conditions {
    public static CommandCondition all(CommandCondition ... conditions) {
        return (sender, commandString) -> {
            for (CommandCondition condition : conditions) {
                if (condition.canUse(sender, commandString)) continue;
                return false;
            }
            return true;
        };
    }

    public static CommandCondition any(CommandCondition ... conditions) {
        return (sender, commandString) -> {
            for (CommandCondition condition : conditions) {
                if (!condition.canUse(sender, commandString)) continue;
                return true;
            }
            return false;
        };
    }

    public static boolean playerOnly(CommandSender sender, String commandString) {
        return sender instanceof Player;
    }

    public static boolean consoleOnly(CommandSender sender, String commandString) {
        return sender instanceof ConsoleSender;
    }
}

