/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.IOException;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentNbtCompoundTag
extends Argument<CompoundBinaryTag> {
    public static final int INVALID_NBT = 1;

    public ArgumentNbtCompoundTag(String id) {
        super(id, true);
    }

    @Override
    @NotNull
    public CompoundBinaryTag parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        try {
            CompoundBinaryTag nbt = TagStringIO.get().asCompound(input);
            if (!(nbt instanceof CompoundBinaryTag)) {
                throw new ArgumentSyntaxException("NBTCompound is invalid", input, 1);
            }
            CompoundBinaryTag compound = nbt;
            return compound;
        }
        catch (IOException e) {
            throw new ArgumentSyntaxException("NBTCompound is invalid", input, 1);
        }
    }

    @Override
    public String parser() {
        return "minecraft:nbt_compound_tag";
    }

    public String toString() {
        return String.format("NbtCompound<%s>", this.getId());
    }
}

