/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minestom.server.command.CommandManager;
import net.minestom.server.command.CommandParser;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandResult;
import net.minestom.server.command.builder.ParsedCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandDispatcher {
    private final CommandManager manager;
    private final Cache<String, CommandResult> cache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public CommandDispatcher(CommandManager manager) {
        this.manager = manager;
    }

    public CommandDispatcher() {
        this(new CommandManager());
    }

    public void register(@NotNull Command command) {
        this.manager.register(command);
    }

    public void unregister(@NotNull Command command) {
        this.manager.unregister(command);
    }

    @NotNull
    public Set<Command> getCommands() {
        return this.manager.getCommands();
    }

    @Nullable
    public Command findCommand(@NotNull String commandName) {
        return this.manager.getCommand(commandName);
    }

    @NotNull
    public CommandResult execute(@NotNull CommandSender source, @NotNull String commandString) {
        return this.manager.execute(source, commandString);
    }

    @NotNull
    public CommandResult parse(@NotNull CommandSender sender, @NotNull String commandString) {
        CommandParser.Result test = this.manager.parseCommand(sender, commandString);
        return CommandDispatcher.resultConverter(test, commandString);
    }

    private static CommandResult resultConverter(CommandParser.Result parseResult, String input) {
        CommandResult.Type type;
        if (parseResult instanceof CommandParser.Result.UnknownCommand) {
            type = CommandResult.Type.UNKNOWN;
        } else if (parseResult instanceof CommandParser.Result.KnownCommand.Valid) {
            type = CommandResult.Type.SUCCESS;
        } else if (parseResult instanceof CommandParser.Result.KnownCommand.Invalid) {
            type = CommandResult.Type.INVALID_SYNTAX;
        } else {
            throw new IllegalStateException("Unknown CommandParser.Result type");
        }
        return CommandResult.of(type, input, ParsedCommand.fromExecutable(parseResult.executable()), null);
    }
}

