/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.packetAdapter.objective;

import net.kyori.adventure.text.format.NamedTextColor;
import net.megavex.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import net.megavex.scoreboardlibrary.implementation.commons.LegacyFormatUtil;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public final class ObjectiveConstants {
    public static final int MODE_CREATE = 0;
    public static final int MODE_REMOVE = 1;
    public static final int MODE_UPDATE = 2;
    public static final int LEGACY_VALUE_CHAR_LIMIT = 32;

    private ObjectiveConstants() {
    }

    public static int mode(@NotNull PropertiesPacketType packetType) {
        switch (packetType) {
            case CREATE: {
                return 0;
            }
            case UPDATE: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public static int displaySlotIndex(@NotNull ObjectiveDisplaySlot slot) {
        return ObjectiveConstants.displaySlotIndex(slot, true);
    }

    public static int displaySlotIndex(@NotNull ObjectiveDisplaySlot slot, boolean isAbove1_8) {
        if (slot instanceof ObjectiveDisplaySlot.PlayerList) {
            return 0;
        }
        if (slot instanceof ObjectiveDisplaySlot.Sidebar || !isAbove1_8 && slot instanceof ObjectiveDisplaySlot.TeamSidebar) {
            return 1;
        }
        if (slot instanceof ObjectiveDisplaySlot.BelowName) {
            return 2;
        }
        NamedTextColor color = ((ObjectiveDisplaySlot.TeamSidebar)slot).teamColor();
        char legacyChar = LegacyFormatUtil.getChar((NamedTextColor)color);
        ChatColor chatColor = ChatColor.getByChar((char)legacyChar);
        return 3 + chatColor.ordinal();
    }
}

