/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.sidebar;

import java.util.Iterator;
import java.util.logging.Level;
import net.megavex.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import net.megavex.scoreboardlibrary.implementation.scheduler.RunningTask;
import net.megavex.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import org.jetbrains.annotations.NotNull;

public class SidebarUpdaterTask
implements Runnable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final RunningTask task;
    private final Object lock = new Object();

    public SidebarUpdaterTask(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
        this.task = scoreboardLibrary.taskScheduler().runEveryTick(this);
    }

    @NotNull
    public RunningTask task() {
        return this.task;
    }

    @NotNull
    public Object lock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<AbstractSidebar> iterator = this.scoreboardLibrary.sidebars().iterator();
            while (iterator.hasNext()) {
                boolean result;
                AbstractSidebar sidebar = iterator.next();
                try {
                    result = sidebar.tick();
                }
                catch (Exception e) {
                    this.scoreboardLibrary.plugin().getLogger().log(Level.WARNING, "an error occurred while updating a Sidebar instance", e);
                    continue;
                }
                if (result) continue;
                iterator.remove();
            }
        }
    }
}

