/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.player;

import net.megavex.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import net.megavex.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import net.megavex.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import net.megavex.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import net.megavex.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import net.megavex.scoreboardlibrary.implementation.sidebar.PlayerDependantLocaleSidebar;
import net.megavex.scoreboardlibrary.implementation.sidebar.SidebarTask;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.jetbrains.annotations.NotNull;

public class LocaleListener
implements Listener {
    private final ScoreboardLibraryImpl scoreboardLibrary;

    public LocaleListener(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerLocaleChanged(PlayerLocaleChangeEvent event) {
        Player player = event.getPlayer();
        this.scoreboardLibrary.taskScheduler().runNextTick(() -> {
            ScoreboardLibraryPlayer slPlayer = this.scoreboardLibrary.getPlayer(player);
            if (slPlayer != null) {
                AbstractSidebar sidebar;
                ObjectiveManagerImpl objectiveManager;
                TeamManagerImpl teamManager = slPlayer.teamManagerQueue().current();
                if (teamManager != null) {
                    teamManager.taskQueue().add(new TeamManagerTask.ReloadPlayer(player));
                }
                if ((objectiveManager = slPlayer.objectiveManagerQueue().current()) != null) {
                    objectiveManager.taskQueue().add(new ObjectiveManagerTask.ReloadPlayer(player));
                }
                if ((sidebar = slPlayer.sidebarQueue().current()) instanceof PlayerDependantLocaleSidebar) {
                    sidebar.taskQueue().add(new SidebarTask.ReloadPlayer(player));
                }
            }
        });
    }
}

