/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.api.sidebar;

import java.util.Collection;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.megavex.scoreboardlibrary.api.objective.ScoreFormat;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface Sidebar {
    public static final int MAX_LINES = 15;

    public @Range(from=1L, to=0x7FFFFFFFL) int maxLines();

    @NotNull
    public String objectiveName();

    @Nullable
    public Locale locale();

    @Nullable
    public Component line(@Range(from=0L, to=0x7FFFFFFEL) int var1);

    default public void line(@Range(from=0L, to=0x7FFFFFFEL) int index, @Nullable ComponentLike value) {
        this.line(index, value, null);
    }

    public void line(@Range(from=0L, to=0x7FFFFFFEL) int var1, @Nullable ComponentLike var2, @Nullable ScoreFormat var3);

    default public void clearLines() {
        for (int i = 0; i < this.maxLines(); ++i) {
            this.line(i, null);
        }
    }

    @NotNull
    public Component title();

    public void title(@NotNull ComponentLike var1);

    @NotNull
    public Collection<Player> players();

    public boolean addPlayer(@NotNull Player var1);

    default public void addPlayers(@NotNull Collection<Player> players) {
        for (Player player : players) {
            this.addPlayer(player);
        }
    }

    public boolean removePlayer(@NotNull Player var1);

    default public void removePlayers(@NotNull Collection<Player> players) {
        for (Player player : players) {
            this.removePlayer(player);
        }
    }

    public void close();

    public boolean closed();
}

