/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat.hover.content;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Entity;

public class EntitySerializer
implements JsonSerializer<Entity>,
JsonDeserializer<Entity> {
    public Entity deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject value;
        boolean newEntity = (value = element.getAsJsonObject()).has("uuid");
        JsonElement uuid = value.get(newEntity ? "uuid" : "id");
        String idString = uuid.isJsonArray() ? EntitySerializer.parseUUID((int[])context.deserialize(uuid, int[].class)).toString() : uuid.getAsString();
        return new Entity(value.has(newEntity ? "id" : "type") ? value.get(newEntity ? "id" : "type").getAsString() : null, idString, value.has("name") ? (BaseComponent)context.deserialize(value.get("name"), BaseComponent.class) : null, newEntity);
    }

    public JsonElement serialize(Entity content, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty(content.isV1_21_5() ? "id" : "type", content.getType() != null ? content.getType() : "minecraft:pig");
        object.addProperty(content.isV1_21_5() ? "uuid" : "id", content.getId());
        if (content.getName() != null) {
            object.add("name", context.serialize((Object)content.getName()));
        }
        return object;
    }

    private static UUID parseUUID(int[] array) {
        return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
    }
}

