/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.updater.universal.v2;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.guizhanss.minecraft.guizhanlib.GuizhanLib;
import net.guizhanss.minecraft.guizhanlib.updater.universal.v2.UniversalUpdater;
import net.guizhanss.minecraft.guizhanlib.updater.universal.v2.UpdaterLocation;
import net.guizhanss.minecraft.guizhanlib.updater.universal.v2.UpdaterRecord;
import org.bukkit.plugin.Plugin;

class UniversalUpdaterTask
implements Runnable {
    private static final String BUILD_PATH = "api/build/%s/%s/%s/latest?status=success";
    private static final String DOWNLOAD_PATH = "api/download/%s/%s/%s/%d";
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static final UpdaterLocation location = UpdaterLocation.getLocation(GuizhanLib.getConfigManager().getUpdaterLocation());
    private final UniversalUpdater updater;
    private Map<String, String> lang;

    @Override
    public void run() {
        if (!this.loadLanguage()) {
            return;
        }
        Config config = GuizhanLib.getConfigManager().getUpdaterConfig();
        if (!((Boolean)config.getOrSetDefault("enable", (Object)true)).booleanValue()) {
            this.log(Level.INFO, this.lang.get("task.global-disabled"), new Object[0]);
            return;
        }
        List<UpdaterRecord> records = this.updater.getRecords();
        this.log(Level.INFO, this.lang.get("loading"), new Object[0]);
        this.log(Level.INFO, this.lang.get("loaded"), records.size());
        for (int i = 0; i < records.size(); ++i) {
            UpdaterRecord r = records.get(i);
            this.log(Level.INFO, "task.running", i + 1, r.plugin().getName());
            this.runTask(r);
        }
        config.save();
    }

    private boolean loadLanguage() {
        InputStream stream;
        GuizhanLib plugin = (GuizhanLib)((Object)GuizhanLib.getInstance());
        try {
            stream = ((Object)((Object)plugin)).getClass().getResourceAsStream("/updater/" + GuizhanLib.getConfigManager().getUpdaterLang() + ".json");
        }
        catch (Exception ex) {
            GuizhanLib.log(Level.WARNING, "Failed to load updater language file, using default en_US.", new Object[0]);
            try {
                stream = ((Object)((Object)plugin)).getClass().getResourceAsStream("/updater/en_US.json");
            }
            catch (Exception e) {
                GuizhanLib.log(Level.SEVERE, "Failed to load default updater language file, please report this!", new Object[0]);
                return false;
            }
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            this.lang = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
            this.log(Level.INFO, "init", new Object[0]);
        }
        catch (Exception ex) {
            GuizhanLib.log(Level.SEVERE, ex, "Failed to load updater language file, please report this!", new Object[0]);
            return false;
        }
        return true;
    }

    private void runTask(@Nonnull UpdaterRecord record) {
        if (!record.plugin().isEnabled()) {
            this.log(Level.INFO, "task.disabled", record.plugin().getName());
            return;
        }
        boolean isGlobalEnabled = (Boolean)GuizhanLib.getConfigManager().getUpdaterConfig().getOrSetDefault("v2." + record.getConfigPath(), (Object)true);
        if (!isGlobalEnabled) {
            this.log(Level.INFO, "task.disabled", record.plugin().getName());
            return;
        }
        try {
            JsonElement buildResp = this.fetchJson(URI.create(location.getBaseUrl() + String.format(BUILD_PATH, record.githubUser(), record.githubRepo(), record.githubBranch())));
            if (buildResp == null) {
                throw new IllegalArgumentException(this.lang.get("tasks.no-info"));
            }
            JsonObject buildResponse = buildResp.getAsJsonObject();
            if (buildResponse.get("code").getAsInt() != 0) {
                throw new IllegalArgumentException(this.lang.get("tasks.no-info"));
            }
            JsonObject build = buildResponse.get("data").getAsJsonObject();
            if (this.isLatest(record.plugin(), build)) {
                this.log(Level.INFO, "task.no-update", record.plugin().getName());
                return;
            }
            if (record.updaterConfig().checkOnly()) {
                this.log(Level.INFO, "task.has-update", record.plugin().getName());
                this.log(Level.INFO, "task.check-only", new Object[0]);
                return;
            }
            int buildId = build.get("id").getAsInt();
            String buildVersion = build.get("target").getAsString().replace(".jar", "").replace(record.plugin().getName() + "-", "");
            this.log(Level.INFO, "task.downloading", record.plugin().getName(), buildVersion);
            this.downloadBuild(record, buildId);
            this.log(Level.INFO, "task.downloaded", record.plugin().getName(), buildVersion);
        }
        catch (Exception ex) {
            this.log(Level.SEVERE, ex, "task.failed", record.plugin().getName());
        }
    }

    @Nullable
    private JsonElement fetchJson(URI uri) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            return (JsonElement)GSON.fromJson(response.body(), JsonElement.class);
        }
        catch (Exception ex) {
            this.log(Level.SEVERE, ex, "task.failed", new Object[0]);
            return null;
        }
    }

    private boolean isLatest(Plugin plugin, JsonObject build) {
        String latestBuildVer = build.get("target").getAsString();
        String currentBuildVer = MessageFormat.format("{0}-{1}.jar", plugin.getName(), plugin.getDescription().getVersion());
        return latestBuildVer.equals(currentBuildVer);
    }

    private void downloadBuild(UpdaterRecord record, int buildId) throws Exception {
        int read;
        BufferedInputStream input = new BufferedInputStream(URI.create(location.getBaseUrl() + String.format(DOWNLOAD_PATH, record.githubUser(), record.githubRepo(), record.githubBranch(), buildId)).toURL().openStream());
        FileOutputStream output = new FileOutputStream(new File("plugins/" + record.plugin().getServer().getUpdateFolder(), record.file().getName()));
        byte[] data = new byte[1024];
        while ((read = input.read(data, 0, 1024)) != -1) {
            output.write(data, 0, read);
        }
        input.close();
        output.close();
    }

    private void log(Level level, String key, Object ... args) {
        String msg = this.lang.get(key) != null ? this.lang.get(key) : key;
        GuizhanLib.log(level, msg, args);
    }

    private void log(Level level, Throwable throwable, String key, Object ... args) {
        String msg;
        String string = msg = this.lang.get(key) != null ? this.lang.get(key) : key;
        if (GuizhanLib.getConfigManager().isDebugEnabled()) {
            GuizhanLib.log(level, throwable, msg, args);
        } else {
            GuizhanLib.log(level, msg, args);
        }
    }

    @Generated
    public UniversalUpdaterTask(UniversalUpdater updater) {
        this.updater = updater;
    }
}

