/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.bs.PinyinBs;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.constant.enums.PinyinStyleEnum;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneStyle;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.style.PinyinToneStyles;

public final class PinyinHelper {
    private static final PinyinBs PINYIN_BS_DEFAULT = PinyinBs.newInstance().init();

    private PinyinHelper() {
    }

    public static String toPinyin(String string) {
        return PINYIN_BS_DEFAULT.toPinyin(string);
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum) {
        return PinyinHelper.toPinyin(string, styleEnum, " ");
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum, String connector) {
        ArgUtil.notNull(connector, "connector");
        if (StringUtil.isEmptyTrim(string)) {
            return string;
        }
        IPinyinToneStyle style = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(style).connector(connector).init().toPinyin(string);
    }

    public static List<String> toPinyinList(char chinese) {
        return PINYIN_BS_DEFAULT.toPinyinList(chinese);
    }

    public static List<String> toPinyinList(char chinese, PinyinStyleEnum styleEnum) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(pinyinTone).init().toPinyinList(chinese);
    }

    public static boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return PINYIN_BS_DEFAULT.hasSamePinyin(chineseOne, chineseTwo);
    }

    public static Map<String, List<String>> samePinyinMap(char hanzi) {
        List<String> pinyinList = PinyinHelper.toPinyinList(hanzi, PinyinStyleEnum.NUM_LAST);
        if (CollectionUtil.isEmpty(pinyinList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(pinyinList.size());
        for (String pinyin : pinyinList) {
            List<String> characterList = PinyinHelper.samePinyinList(pinyin);
            map.put(pinyin, characterList);
        }
        return map;
    }

    public static List<String> samePinyinList(String pinyinNumLast) {
        boolean sameTone = true;
        return PINYIN_BS_DEFAULT.samePinyinList(pinyinNumLast, true);
    }
}

