/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.StreamUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneReverse;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneStyle;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.style.PinyinToneStyles;

@ThreadSafe
public class PinyinToneReverse
implements IPinyinToneReverse {
    private static final Map<String, List<String>> CHAR_MAP;

    @Override
    public List<String> getHanziList(String pinyinLast) {
        return CHAR_MAP.get(pinyinLast);
    }

    static {
        List<String> lines = StreamUtil.readAllLines("/pinyin_dict_char.txt");
        List<String> defineLines = StreamUtil.readAllLines("/pinyin_dict_char_define.txt");
        lines.addAll(defineLines);
        CHAR_MAP = Guavas.newHashMap(lines.size());
        IPinyinToneStyle pinyinToneStyle = PinyinToneStyles.numLast();
        for (String line : lines) {
            String[] strings = line.split(":");
            List<String> pinyinList = StringUtil.splitToList(strings[1]);
            String hanzi = strings[0];
            for (String pinyin : pinyinList) {
                String pinyinNumLast = pinyinToneStyle.style(pinyin);
                List<String> hanziList = CHAR_MAP.get(pinyinNumLast);
                if (hanziList == null) {
                    hanziList = new ArrayList<String>();
                }
                hanziList.add(hanzi);
                CHAR_MAP.put(pinyinNumLast, hanziList);
            }
        }
    }
}

