/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.StreamUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.constant.enums.PinyinToneNumEnum;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.model.CharToneInfo;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.model.ToneItem;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneStyle;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone.AbstractPinyinTone;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.util.InnerToneHelper;

@ThreadSafe
public class DefaultPinyinTone
extends AbstractPinyinTone {
    private static volatile Map<String, List<String>> charMap;
    private static volatile Map<String, String> phraseMap;

    @Override
    protected List<String> getCharTones(String chinese, final IPinyinToneStyle toneStyle) {
        List<String> defaultList = this.getCharMap().get(chinese);
        return CollectionUtil.toList(defaultList, new IHandler<String, String>(){

            @Override
            public String handle(String s) {
                return toneStyle.style(s);
            }
        });
    }

    @Override
    protected String getCharTone(String segment, IPinyinToneStyle toneStyle) {
        List<String> pinyinList = this.getCharMap().get(segment);
        if (CollectionUtil.isNotEmpty(pinyinList)) {
            String firstPinyin = pinyinList.get(0);
            return toneStyle.style(firstPinyin);
        }
        return null;
    }

    @Override
    protected String getPhraseTone(String segment, IPinyinToneStyle toneStyle, String connector) {
        String phrasePinyin = this.getPhraseMap().get(segment);
        if (StringUtil.isEmptyTrim(phrasePinyin)) {
            return "";
        }
        String[] strings = phrasePinyin.split(" ");
        List<String> resultList = Guavas.newArrayList(strings.length);
        for (String string : strings) {
            String style = toneStyle.style(string);
            resultList.add(style);
        }
        return StringUtil.join(resultList, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getCharMap() {
        if (ObjectUtil.isNotNull(charMap)) {
            return charMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtil.isNull(charMap)) {
                List<String> lines = StreamUtil.readAllLines("/pinyin_dict_char.txt");
                List<String> defineLines = StreamUtil.readAllLines("/pinyin_dict_char_define.txt");
                lines.addAll(defineLines);
                charMap = Guavas.newHashMap(lines.size());
                for (String line : lines) {
                    String[] strings = line.split(":");
                    List<String> pinyinList = StringUtil.splitToList(strings[1]);
                    String word = strings[0];
                    charMap.put(word, pinyinList);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return charMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPhraseMap() {
        if (ObjectUtil.isNotNull(phraseMap)) {
            return phraseMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtil.isNull(phraseMap)) {
                List<String> lines = StreamUtil.readAllLines("/pinyin_dict_phrase.txt");
                List<String> defineLines = StreamUtil.readAllLines("/pinyin_dict_phrase_define.txt");
                lines.addAll(defineLines);
                phraseMap = Guavas.newHashMap(lines.size());
                for (String line : lines) {
                    String[] strings = line.split(":");
                    String word = strings[0];
                    phraseMap.put(word, strings[1]);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return phraseMap;
        }
    }

    @Override
    public Set<String> phraseSet() {
        Map<String, String> map = this.getPhraseMap();
        return map.keySet();
    }

    @Override
    public int toneNum(String defaultPinyin) {
        if (StringUtil.isNotEmpty(defaultPinyin)) {
            CharToneInfo toneInfo = this.getCharToneInfo(defaultPinyin);
            int index = toneInfo.getIndex();
            if (index < 0) {
                return PinyinToneNumEnum.FIVE.num();
            }
            return toneInfo.getToneItem().getTone();
        }
        return PinyinToneNumEnum.UN_KNOWN.num();
    }

    protected CharToneInfo getCharToneInfo(String tone) {
        CharToneInfo charToneInfo = new CharToneInfo();
        charToneInfo.setIndex(-1);
        int length = tone.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = tone.charAt(i);
            ToneItem toneItem = InnerToneHelper.getToneItem(currentChar);
            if (!ObjectUtil.isNotNull(toneItem)) continue;
            charToneInfo.setToneItem(toneItem);
            charToneInfo.setIndex(i);
            break;
        }
        return charToneInfo;
    }
}

