/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone;

import java.util.Collections;
import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.IPinyinContext;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinTone;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneStyle;

public abstract class AbstractPinyinTone
implements IPinyinTone {
    protected abstract String getCharTone(String var1, IPinyinToneStyle var2);

    protected abstract List<String> getCharTones(String var1, IPinyinToneStyle var2);

    protected abstract String getPhraseTone(String var1, IPinyinToneStyle var2, String var3);

    @Override
    public String tone(String segment, IPinyinContext context) {
        String result;
        int length = segment.length();
        final IPinyinToneStyle toneStyle = context.style();
        String connector = context.connector();
        if (length == 1) {
            this.getCharToneDefault(segment, toneStyle);
        }
        if (StringUtil.isNotEmpty(result = this.getPhraseTone(segment, toneStyle, connector))) {
            return result;
        }
        List<String> chars = StringUtil.toCharStringList(segment);
        List<String> tones = CollectionUtil.toList(chars, new IHandler<String, String>(){

            @Override
            public String handle(String string) {
                return AbstractPinyinTone.this.getCharToneDefault(string, toneStyle);
            }
        });
        return StringUtil.join(tones, " ");
    }

    private String getCharToneDefault(String string, IPinyinToneStyle toneStyle) {
        String pinyin = this.getCharTone(string, toneStyle);
        if (StringUtil.isNotEmpty(pinyin)) {
            return pinyin;
        }
        return string;
    }

    @Override
    public List<String> toneList(String chinese, IPinyinContext context) {
        IPinyinToneStyle toneStyle = context.style();
        return this.getCharTonesDefault(chinese, toneStyle);
    }

    private List<String> getCharTonesDefault(String chinese, IPinyinToneStyle toneStyle) {
        List<String> toneList = this.getCharTones(chinese, toneStyle);
        if (CollectionUtil.isNotEmpty(toneList)) {
            return toneList;
        }
        return Collections.singletonList(chinese);
    }
}

