/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.bs;

import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.instance.impl.Instances;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.IPinyin;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.IPinyinContext;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.impl.Pinyin;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.impl.PinyinContext;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinChinese;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinData;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinSegment;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinTone;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneReverse;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneStyle;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.chinese.PinyinChineses;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.data.PinyinData;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.segment.PinyinSegments;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.style.PinyinToneStyles;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone.PinyinToneReverse;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.support.tone.PinyinTones;

public final class PinyinBs {
    private IPinyinSegment pinyinSegment = PinyinSegments.defaults();
    private final IPinyinChinese pinyinChinese = PinyinChineses.defaults();
    private final IPinyinTone pinyinTone = PinyinTones.defaults();
    private final IPinyinData data = Instances.singleton(PinyinData.class);
    private IPinyinToneStyle style = PinyinToneStyles.defaults();
    private final IPinyin pinyin = Instances.singleton(Pinyin.class);
    private String connector = " ";
    private IPinyinToneReverse pinyinToneReverse = new PinyinToneReverse();
    private IPinyinContext pinyinContext;

    private PinyinBs() {
    }

    public static PinyinBs newInstance() {
        return new PinyinBs();
    }

    public PinyinBs style(IPinyinToneStyle style) {
        ArgUtil.notNull(style, "style");
        this.style = style;
        return this;
    }

    public PinyinBs connector(String connector) {
        this.connector = connector;
        return this;
    }

    public PinyinBs segment(IPinyinSegment pinyinSegment) {
        ArgUtil.notNull(pinyinSegment, "segment");
        this.pinyinSegment = pinyinSegment;
        return this;
    }

    public PinyinBs pinyinToneReverse(IPinyinToneReverse pinyinToneReverse) {
        ArgUtil.notNull(pinyinToneReverse, "pinyinToneReverse");
        this.pinyinToneReverse = pinyinToneReverse;
        return this;
    }

    public PinyinBs init() {
        this.pinyinContext = PinyinContext.newInstance().chinese(this.pinyinChinese).data(this.data).segment(this.pinyinSegment).style(this.style).tone(this.pinyinTone).connector(this.connector).pinyinToneReverse(this.pinyinToneReverse);
        return this;
    }

    private synchronized void statusCheck() {
        if (this.pinyinContext == null) {
            this.init();
        }
    }

    public String toPinyin(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        this.statusCheck();
        return this.pinyin.toPinyin(string, this.pinyinContext);
    }

    public List<String> toPinyinList(char chinese) {
        this.statusCheck();
        return this.pinyin.toPinyinList(chinese, this.pinyinContext);
    }

    public boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        this.statusCheck();
        return this.pinyin.hasSamePinyin(chineseOne, chineseTwo, this.pinyinContext);
    }

    public List<String> samePinyinList(String pinyin, boolean sameTone) {
        this.statusCheck();
        return this.pinyin.samePinyinList(pinyin, sameTone, this.pinyinContext);
    }
}

