/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.IPinyin;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.api.IPinyinContext;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinChinese;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinData;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinSegment;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinTone;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.pinyin.spi.IPinyinToneReverse;

@ThreadSafe
public class Pinyin
implements IPinyin {
    @Override
    public String toPinyin(String string, IPinyinContext context) {
        List<String> stringList = this.toPinyinList(string, context);
        String connector = context.connector();
        return StringUtil.join(stringList, connector);
    }

    @Override
    public List<String> toPinyinList(char chinese, IPinyinContext context) {
        String original = String.valueOf(chinese);
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(original)) {
            String simple = pinyinChinese.toSimple(original);
            return pinyinTone.toneList(simple, context);
        }
        return Collections.singletonList(original);
    }

    @Override
    public boolean hasSamePinyin(char chineseOne, char chineseTwo, IPinyinContext context) {
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(chineseOne) && pinyinChinese.isChinese(chineseTwo)) {
            if (chineseOne == chineseTwo) {
                return true;
            }
            String simpleOne = pinyinChinese.toSimple(chineseOne);
            String simpleTwo = pinyinChinese.toSimple(chineseTwo);
            List<String> tonesOne = pinyinTone.toneList(simpleOne, context);
            List<String> tonesTwo = pinyinTone.toneList(simpleTwo, context);
            return CollectionUtil.containAny(tonesOne, tonesTwo);
        }
        return false;
    }

    @Override
    public List<Integer> toneNumList(String chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    public List<Integer> toneNumList(char chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    public List<String> shengMuList(String chinese, IPinyinContext context) {
        final IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, new IHandler<String, String>(){

            @Override
            public String handle(String s) {
                return pinyinData.shengMu(s);
            }
        });
    }

    @Override
    public List<String> yunMuList(String chinese, IPinyinContext context) {
        final IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, new IHandler<String, String>(){

            @Override
            public String handle(String s) {
                return pinyinData.yunMu(s);
            }
        });
    }

    @Override
    public List<String> samePinyinList(String pinyin, boolean sameToneNum, IPinyinContext context) {
        IPinyinToneReverse pinyinToneReverse = context.pinyinToneReverse();
        if (sameToneNum) {
            return pinyinToneReverse.getHanziList(pinyin);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String pinyinRaw = pinyin.substring(0, pinyin.length() - 1);
        for (int i = 1; i <= 5; ++i) {
            String pinyinLast = pinyinRaw + i;
            List<String> characterList = pinyinToneReverse.getHanziList(pinyinLast);
            if (!CollectionUtil.isNotEmpty(characterList)) continue;
            resultList.addAll(characterList);
        }
        return resultList;
    }

    private List<String> toPinyinList(String string, IPinyinContext context) {
        if (StringUtil.isEmptyTrim(string)) {
            return Collections.emptyList();
        }
        IPinyinSegment pinyinSegment = context.segment();
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        List<String> entryList = pinyinSegment.segment(string);
        List<String> resultList = Guavas.newArrayList(entryList.size());
        for (String entry : entryList) {
            if (StringUtil.isEmptyTrim(entry)) continue;
            if (pinyinChinese.isChinese(entry)) {
                String simple = pinyinChinese.toSimple(entry);
                String tone = pinyinTone.tone(simple, context);
                resultList.add(tone);
                continue;
            }
            resultList.add(entry);
        }
        return resultList;
    }

    private List<Integer> buildToneNumList(List<String> pinyinList, IPinyinTone pinyinTone) {
        List<Integer> resultList = Guavas.newArrayList(pinyinList.size());
        for (String pinyin : pinyinList) {
            Integer toneNum = pinyinTone.toneNum(pinyin);
            resultList.add(toneNum);
        }
        return resultList;
    }

    private List<String> normalPinyinHandler(String chinese, IPinyinContext context, IHandler<String, String> handler) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        List<String> resultList = Guavas.newArrayList(pinyinList.size());
        for (String pinyin : pinyinList) {
            String result = handler.handle(pinyin);
            resultList.add(result);
        }
        return resultList;
    }
}

