/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.segment.impl;

import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.CharUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.segment.impl.AbstractCommonSegment;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.util.CharUtils;

@ThreadSafe
public class SimpleCommonSegment
extends AbstractCommonSegment {
    @Override
    protected List<String> doSegment(String text) {
        List<String> wordList = Guavas.newArrayList();
        StringBuilder chineseBuffer = new StringBuilder();
        StringBuilder otherBuffer = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (CharUtil.isChinese(c)) {
                chineseBuffer.append(c);
                this.processOtherChars(otherBuffer, wordList);
                continue;
            }
            otherBuffer.append(c);
            this.processChineseChars(chineseBuffer, wordList);
        }
        this.processChineseChars(chineseBuffer, wordList);
        this.processOtherChars(otherBuffer, wordList);
        return wordList;
    }

    protected List<String> getChineseSegments(String text) {
        return StringUtil.toCharStringList(text);
    }

    private void processChineseChars(StringBuilder buffer, List<String> wordList) {
        int length = buffer.length();
        if (length <= 0) {
            return;
        }
        String text = buffer.toString();
        List<String> segments = this.getChineseSegments(text);
        wordList.addAll(segments);
        buffer.setLength(0);
    }

    private void processOtherChars(StringBuilder buffer, List<String> wordList) {
        int length = buffer.length();
        if (length <= 0) {
            return;
        }
        if (1 == length) {
            wordList.add(buffer.toString());
        } else {
            StringBuilder wordBuffer = new StringBuilder();
            for (int i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (CharUtil.isDigitOrLetter(c) || CharUtils.isLetterOrConnector(c)) {
                    wordBuffer.append(c);
                    continue;
                }
                if (wordBuffer.length() > 0) {
                    wordList.add(wordBuffer.toString());
                    wordBuffer.setLength(0);
                }
                wordList.add(String.valueOf(c));
            }
            if (wordBuffer.length() > 0) {
                wordList.add(wordBuffer.toString());
                wordBuffer.setLength(0);
            }
        }
        buffer.setLength(0);
    }
}

