/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl;

import java.util.List;
import java.util.Map;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.StreamUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.ICharFormat;

@ThreadSafe
public class ChineseTsCharFormat
implements ICharFormat {
    private static final Map<Character, Character> TS_CHAR_MAP = Guavas.newHashMap();

    @Override
    public char format(char ch) {
        Character simple = TS_CHAR_MAP.get(Character.valueOf(ch));
        if (ObjectUtil.isNull(simple)) {
            return ch;
        }
        return simple.charValue();
    }

    static {
        long startTime = System.currentTimeMillis();
        List<String> lines = StreamUtil.readAllLines("/nlp/chinese_ts_char.txt");
        for (String line : lines) {
            String[] entries = line.split(" ");
            char tChar = entries[0].charAt(0);
            char sChar = entries[1].charAt(0);
            TS_CHAR_MAP.put(Character.valueOf(tChar), Character.valueOf(sChar));
        }
        long costTime = System.currentTimeMillis() - startTime;
        System.out.println("[NLP Format] chinese traditional-simple dict load finished, cost " + costTime + " ms");
    }
}

